/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.posix.PosixSystemPropertiesSupport;
import com.oracle.svm.core.posix.darwin.DarwinCoreFoundationUtils;
import com.oracle.svm.core.posix.headers.Limits;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.CoreFoundation;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.DARWIN_AND_JNI.class})
public class DarwinSystemPropertiesSupport
extends PosixSystemPropertiesSupport {
    private static volatile String osVersionValue = null;

    @Override
    protected String tmpdirValue() {
        int buflen = Limits.PATH_MAX();
        CCharPointer tmpPath = (CCharPointer)StackValue.get((int)buflen);
        UnsignedWord pathSize = Unistd.confstr(Unistd._CS_DARWIN_USER_TEMP_DIR(), tmpPath, WordFactory.unsigned((int)buflen));
        if (pathSize.aboveThan(0) && pathSize.belowOrEqual(buflen)) {
            return CTypeConversion.toJavaString((CCharPointer)tmpPath);
        }
        return "/var/tmp";
    }

    @Override
    protected String osVersionValue() {
        if (osVersionValue != null) {
            return osVersionValue;
        }
        CoreFoundation.CFDictionaryRef dict = CoreFoundation._CFCopyServerVersionDictionary();
        if (dict.isNull()) {
            dict = CoreFoundation._CFCopySystemVersionDictionary();
        }
        if (dict.isNull()) {
            osVersionValue = "Unknown";
            return "Unknown";
        }
        CoreFoundation.CFMutableStringRef dictKeyRef = DarwinCoreFoundationUtils.toCFStringRef("MacOSXProductVersion");
        CoreFoundation.CFStringRef dictValue = CoreFoundation.CFDictionaryGetValue(dict, dictKeyRef);
        CoreFoundation.CFRelease(dictKeyRef);
        if (dictValue.isNull()) {
            dictKeyRef = DarwinCoreFoundationUtils.toCFStringRef("ProductVersion");
            dictValue = CoreFoundation.CFDictionaryGetValue(dict, dictKeyRef);
            CoreFoundation.CFRelease(dictKeyRef);
        }
        if (dictValue.isNonNull()) {
            dictValue = (CoreFoundation.CFStringRef)CoreFoundation.CFRetain(dictValue);
            osVersionValue = DarwinCoreFoundationUtils.fromCFStringRef(dictValue);
            CoreFoundation.CFRelease(dictValue);
        } else {
            osVersionValue = "Unknown";
        }
        return osVersionValue;
    }
}

