/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.posix.PosixProcessPropertiesSupport;
import com.oracle.svm.core.posix.headers.darwin.DarwinDyld;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.ProcessPropertiesSupport;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.DARWIN_AND_JNI.class})
public class DarwinProcessPropertiesSupport
extends PosixProcessPropertiesSupport {
    public String getExecutableName() {
        CIntPointer sizePointer = (CIntPointer)StackValue.get(CIntPointer.class);
        sizePointer.write(0);
        if (DarwinDyld._NSGetExecutablePath((CCharPointer)WordFactory.nullPointer(), sizePointer) != -1) {
            VMError.shouldNotReachHere("DarwinProcessPropertiesSupport.getExecutableName: Executable path length is 0?");
        }
        byte[] byteBuffer = new byte[sizePointer.read()];
        try (PinnedObject pinnedBuffer = PinnedObject.create((Object)byteBuffer);){
            CCharPointer bufferPointer = (CCharPointer)pinnedBuffer.addressOfArrayElement(0);
            if (DarwinDyld._NSGetExecutablePath(bufferPointer, sizePointer) == -1) {
                String string = null;
                return string;
            }
            String executableString = CTypeConversion.toJavaString((CCharPointer)bufferPointer);
            String string = DarwinProcessPropertiesSupport.realpath(executableString);
            return string;
        }
    }

    @AutomaticFeature
    public static class ImagePropertiesFeature
    implements Feature {
        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(ProcessPropertiesSupport.class, (Object)new DarwinProcessPropertiesSupport());
        }
    }
}

