/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.headers.LibC;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
class VmPrimsJNI {
    private VmPrimsJNI() {
    }

    static void GetByteArrayRegion(byte[] array, int start, int len, CCharPointer buf) {
        if (start < 0 || len < 0 || (long)start + (long)len > (long)array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len > 0) {
            try (PinnedObject pin = PinnedObject.create((Object)array);){
                LibC.memcpy(buf, pin.addressOfArrayElement(start), WordFactory.unsigned((int)len));
            }
        }
    }

    static void SetByteArrayRegion(byte[] array, int start, int len, CCharPointer buf) {
        if (start < 0 || len < 0 || (long)start + (long)len > (long)array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len > 0) {
            try (PinnedObject pin = PinnedObject.create((Object)array);){
                LibC.memcpy(pin.addressOfArrayElement(start), (PointerBase)buf, WordFactory.unsigned((int)len));
            }
        }
    }
}

