/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.posix.Package_jdk_internal_misc;
import com.oracle.svm.core.posix.Util_jdk_internal_misc_Signal;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
@TargetClass(classNameProvider=Package_jdk_internal_misc.class, className="Signal")
final class Target_jdk_internal_misc_Signal {
    Target_jdk_internal_misc_Signal() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static int findSignal(String signalName) {
        return Util_jdk_internal_misc_Signal.numberFromName(signalName);
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private static int findSignal0(String signalName) {
        return Util_jdk_internal_misc_Signal.numberFromName(signalName);
    }

    @Substitute
    private static long handle0(int sig, long nativeH) {
        if (ImageInfo.isSharedLibrary()) {
            throw new IllegalArgumentException("Installing signal handlers is not allowed for native-image shared libraries.");
        }
        return Util_jdk_internal_misc_Signal.handle0(sig, nativeH);
    }

    @Substitute
    private static void raise0(int signalNumber) {
        Signal.raise(signalNumber);
    }

    @Alias
    static native void dispatch(int var0);
}

