/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.PosixInterruptSignalUtils;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Poll;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Uio;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntSupplier;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
public abstract class PosixJavaNetClose {
    private static final Map<Integer, FdEntry> fdTable = new ConcurrentHashMap<Integer, FdEntry>();

    protected static FdEntry getFdEntry(int fd) {
        return fdTable.computeIfAbsent(fd, unused -> new FdEntry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void startOp(FdEntry fdEntry, ThreadEntry self) {
        self.setPThread(Pthread.pthread_self());
        self.setIntr(false);
        FdEntry fdEntry2 = fdEntry;
        synchronized (fdEntry2) {
            fdEntry.getThreadList().add(self);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void endOp(FdEntry fdEntry, ThreadEntry self) {
        boolean badErrno = false;
        FdEntry fdEntry2 = fdEntry;
        synchronized (fdEntry2) {
            fdEntry.getThreadList().remove(self);
            if (self.getIntr()) {
                badErrno = true;
            }
        }
        if (badErrno) {
            Errno.set_errno(Errno.EBADF());
        }
    }

    protected abstract int closefd(int var1, int var2);

    protected void interruptThread(Pthread.pthread_t pThread) {
        try {
            PosixInterruptSignalUtils.interruptPThread(pThread);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int BLOCKING_IO_RETURN_INT(int FD, IntSupplier FUNC) {
        int ret;
        FdEntry fdEntry = PosixJavaNetClose.getFdEntry(FD);
        if (fdEntry == null) {
            Errno.set_errno(Errno.EBADF());
            return -1;
        }
        ThreadEntry self = new ThreadEntry();
        do {
            PosixJavaNetClose.startOp(fdEntry, self);
            ret = FUNC.getAsInt();
            PosixJavaNetClose.endOp(fdEntry, self);
        } while (ret == -1 && Errno.errno() == Errno.EINTR());
        return ret;
    }

    public int NET_Dup2(int fd, int fd2) {
        if (fd < 0) {
            Errno.set_errno(Errno.EBADF());
            return -1;
        }
        return this.closefd(fd, fd2);
    }

    public int NET_SocketClose(int fd) {
        return this.closefd(-1, fd);
    }

    public int NET_Read(int s, PointerBase buf, long len) {
        return this.BLOCKING_IO_RETURN_INT(s, () -> (int)Socket.recv(s, buf, WordFactory.unsigned((long)len), 0).rawValue());
    }

    public int NET_NonBlockingRead(int s, PointerBase buf, long len) {
        return this.BLOCKING_IO_RETURN_INT(s, () -> (int)Socket.recv(s, buf, WordFactory.unsigned((long)len), Socket.MSG_DONTWAIT()).rawValue());
    }

    public int NET_ReadV(int s, Uio.iovec vector, int count) {
        return this.BLOCKING_IO_RETURN_INT(s, () -> (int)Uio.readv(s, vector, count).rawValue());
    }

    public int NET_RecvFrom(int s, PointerBase buf, int len, int flags, Socket.sockaddr from, CIntPointer fromlen) {
        return this.BLOCKING_IO_RETURN_INT(s, () -> (int)Socket.recvfrom(s, buf, WordFactory.unsigned((int)len), flags, from, fromlen).rawValue());
    }

    public int NET_Send(int s, PointerBase msg, int len, int flags) {
        return this.BLOCKING_IO_RETURN_INT(s, () -> (int)Socket.send(s, msg, WordFactory.unsigned((int)len), flags).rawValue());
    }

    public int NET_WriteV(int s, Uio.iovec vector, int count) {
        return this.BLOCKING_IO_RETURN_INT(s, () -> (int)Uio.writev(s, vector, count).rawValue());
    }

    public int NET_SendTo(int s, PointerBase msg, int len, int flags, Socket.sockaddr to, int tolen) {
        return this.BLOCKING_IO_RETURN_INT(s, () -> (int)Socket.sendto(s, msg, WordFactory.unsigned((int)len), flags, to, tolen).rawValue());
    }

    public int NET_Connect(int s, Socket.sockaddr addr, int addrlen) {
        return this.BLOCKING_IO_RETURN_INT(s, () -> Socket.connect(s, addr, addrlen));
    }

    public int NET_Poll(Poll.pollfd ufds, int nfds, int timeout) {
        return this.BLOCKING_IO_RETURN_INT(ufds.fd(), () -> Poll.poll(ufds, nfds, timeout));
    }

    public abstract int NET_Timeout0(int var1, long var2, long var4);

    public abstract int NET_Accept(int var1, Socket.sockaddr var2, CIntPointer var3);

    protected static class FdEntry {
        private final List<ThreadEntry> threadList = new ArrayList<ThreadEntry>(2);

        public List<ThreadEntry> getThreadList() {
            return this.threadList;
        }
    }

    protected static class ThreadEntry {
        private Pthread.pthread_t pThread;
        private boolean intr;

        public Pthread.pthread_t getPThread() {
            return this.pThread;
        }

        public void setPThread(Pthread.pthread_t pThreadArg) {
            this.pThread = pThreadArg;
        }

        public boolean getIntr() {
            return this.intr;
        }

        public void setIntr(boolean value) {
            this.intr = value;
        }
    }
}

