/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.graalvm.compiler.options.NestedBooleanOptionKey;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.RuntimeOptions;
import org.graalvm.nativeimage.impl.RuntimeOptionsSupport;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionType;

class RuntimeOptionsSupportImpl
implements RuntimeOptionsSupport {
    private static final Map<Class<?>, OptionType<?>> ENUM_TYPE_CACHE = new HashMap();
    private static final OptionType<Long> LONG_OPTION_TYPE = new OptionType("long", (Object)0L, RuntimeOptionsSupportImpl::parseLong);

    RuntimeOptionsSupportImpl() {
    }

    public void set(String optionName, Object value) {
        if (RuntimeOptionsSupportImpl.setXOption(optionName)) {
            return;
        }
        if (!RuntimeOptionValues.singleton().getAllOptionNames().contains((Object)optionName)) {
            throw new RuntimeException("Unknown option: " + optionName);
        }
        Optional<OptionDescriptor> descriptor = RuntimeOptionParser.singleton().getDescriptor(optionName);
        if (descriptor.isPresent()) {
            OptionDescriptor desc = descriptor.get();
            Class<?> valueType = value.getClass();
            if (desc.getOptionValueType().isAssignableFrom(valueType)) {
                RuntimeOptionValues.singleton().update(desc.getOptionKey(), value);
            } else {
                throw new RuntimeException("Invalid type of option '" + optionName + "': required " + desc.getOptionValueType().getSimpleName() + ", provided " + valueType);
            }
        }
    }

    public <T> T get(String optionName) {
        if (!RuntimeOptionValues.singleton().getAllOptionNames().contains((Object)optionName)) {
            throw new RuntimeException("Unknown option: " + optionName);
        }
        Optional<OptionDescriptor> descriptor = RuntimeOptionParser.singleton().getDescriptor(optionName);
        OptionKey optionKey = descriptor.orElseThrow(() -> new RuntimeException("Option " + optionName + " exists but it is not reachable in the application. It is not possible to get its value.")).getOptionKey();
        return (T)optionKey.getValue((OptionValues)RuntimeOptionValues.singleton());
    }

    public OptionDescriptors getOptions(EnumSet<RuntimeOptions.OptionClass> classes) {
        Collection<OptionDescriptor> descriptors = RuntimeOptionParser.singleton().getDescriptors();
        ArrayList<org.graalvm.options.OptionDescriptor> graalvmDescriptors = new ArrayList<org.graalvm.options.OptionDescriptor>(descriptors.size());
        for (OptionDescriptor descriptor : descriptors) {
            if (!classes.contains(RuntimeOptionsSupportImpl.getOptionClass(descriptor))) continue;
            OptionDescriptor.Builder builder = org.graalvm.options.OptionDescriptor.newBuilder(RuntimeOptionsSupportImpl.asGraalVMOptionKey(descriptor), (String)descriptor.getName());
            String helpMsg = descriptor.getHelp();
            int helpLen = helpMsg.length();
            if (helpLen > 0 && helpMsg.charAt(helpLen - 1) != '.') {
                helpMsg = helpMsg + '.';
            }
            builder.help(helpMsg);
            graalvmDescriptors.add(builder.build());
        }
        return OptionDescriptors.create(graalvmDescriptors);
    }

    private static RuntimeOptions.OptionClass getOptionClass(OptionDescriptor descriptor) {
        if (descriptor.getOptionKey() instanceof RuntimeOptionKey) {
            return RuntimeOptions.OptionClass.VM;
        }
        return RuntimeOptions.OptionClass.Compiler;
    }

    private static <T> org.graalvm.options.OptionKey<T> asGraalVMOptionKey(OptionDescriptor descriptor) {
        OptionType type;
        Class clazz = descriptor.getOptionValueType();
        if (clazz.isEnum()) {
            type = ENUM_TYPE_CACHE.computeIfAbsent(clazz, c -> new OptionType(c.getSimpleName(), null, s -> Enum.valueOf(c, s)));
        } else if (clazz == Long.class) {
            type = LONG_OPTION_TYPE;
        } else {
            type = OptionType.defaultType((Class)clazz);
            if (type == null) {
                throw VMError.shouldNotReachHere("unsupported type: " + clazz);
            }
        }
        OptionKey optionKey = descriptor.getOptionKey();
        while (optionKey instanceof NestedBooleanOptionKey) {
            optionKey = ((NestedBooleanOptionKey)optionKey).getMasterOption();
        }
        Object defaultValue = optionKey.getDefaultValue();
        return new org.graalvm.options.OptionKey(defaultValue, type);
    }

    private static long parseLong(String v) {
        String valueString = v.toLowerCase();
        long scale = 1L;
        if (valueString.endsWith("k")) {
            scale = 1024L;
        } else if (valueString.endsWith("m")) {
            scale = 0x100000L;
        } else if (valueString.endsWith("g")) {
            scale = 0x40000000L;
        } else if (valueString.endsWith("t")) {
            scale = 0x10000000000L;
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    private static boolean setXOption(String keyAndValue) {
        for (XOptions.XFlag xFlag : XOptions.singleton().getXFlags()) {
            if (!keyAndValue.startsWith(xFlag.getName())) continue;
            String valueString = keyAndValue.substring(xFlag.getName().length());
            try {
                XOptions.singleton().parseFromValueString(xFlag, valueString);
                return true;
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Invalid option '" + xFlag.getPrefixAndName() + valueString + "' does not specify a valid number.");
            }
        }
        return false;
    }
}

