/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.UnsafeAccess;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.VarHandleInfo;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Feature;

@AutomaticFeature
public class VarHandleFeature
implements Feature {
    private final Map<Class<?>, VarHandleInfo> infos = new HashMap();
    private final ConcurrentMap<Object, Boolean> processedVarHandles = new ConcurrentHashMap<Object, Boolean>();
    private Consumer<Field> markAsUnsafeAccessed;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !JavaVersionUtil.Java8OrEarlier;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        try {
            for (String typeName : new String[]{"Booleans", "Bytes", "Chars", "Doubles", "Floats", "Ints", "Longs", "Shorts", "Objects"}) {
                this.buildInfo(false, "receiverType", Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldInstanceReadOnly"), Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldInstanceReadWrite"));
                this.buildInfo(true, "base", Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldStaticReadOnly"), Class.forName("java.lang.invoke.VarHandle" + typeName + "$FieldStaticReadWrite"));
            }
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void buildInfo(boolean isStatic, String typeFieldName, Class<?> readOnlyClass, Class<?> readWriteClass) throws ReflectiveOperationException {
        VarHandleInfo info = new VarHandleInfo(isStatic, VarHandleFeature.getDeclaredField(readOnlyClass, "fieldOffset"), VarHandleFeature.getDeclaredField(readOnlyClass, typeFieldName));
        this.infos.put(readOnlyClass, info);
        this.infos.put(readWriteClass, info);
    }

    private static Field getDeclaredField(Class<?> clazz, String fieldName) throws ReflectiveOperationException {
        Field result = clazz.getDeclaredField(fieldName);
        result.setAccessible(true);
        return result;
    }

    Field findVarHandleField(Object varHandle) {
        try {
            Class type;
            VarHandleInfo info = this.infos.get(varHandle.getClass());
            long originalFieldOffset = info.fieldOffsetField.getLong(varHandle);
            for (Class cur = type = (Class)info.typeField.get(varHandle); cur != null; cur = cur.getSuperclass()) {
                for (Field field : cur.getDeclaredFields()) {
                    long fieldOffset;
                    if (Modifier.isStatic(field.getModifiers()) != info.isStatic) continue;
                    long l = fieldOffset = info.isStatic ? UnsafeAccess.UNSAFE.staticFieldOffset(field) : UnsafeAccess.UNSAFE.objectFieldOffset(field);
                    if (fieldOffset != originalFieldOffset) continue;
                    return field;
                }
                if (info.isStatic) break;
            }
            throw VMError.shouldNotReachHere("Could not find field referenced in VarHandle: " + type + ", offset = " + originalFieldOffset + ", isStatic = " + info.isStatic);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::processVarHandle);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.markAsUnsafeAccessed = arg_0 -> ((Feature.BeforeAnalysisAccess)access).registerAsUnsafeAccessed(arg_0);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.markAsUnsafeAccessed = null;
    }

    private Object processVarHandle(Object obj) {
        VarHandleInfo info = this.infos.get(obj.getClass());
        if (info != null && this.processedVarHandles.putIfAbsent(obj, true) == null) {
            VMError.guarantee(this.markAsUnsafeAccessed != null, "New VarHandle found after static analysis");
            Field field = this.findVarHandleField(obj);
            if (info.isStatic) {
                System.out.println("WARNING GR-10238: VarHandle for static field is currently not fully supported. Static field " + field + " is not properly marked for Unsafe access!");
            } else {
                this.markAsUnsafeAccessed.accept(field);
            }
        }
        return obj;
    }
}

