/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.jdk.Target_java_lang_NamedPackage;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@TargetClass(value=ClassLoader.class)
@Substitute
public final class Target_java_lang_ClassLoader {
    @Substitute
    private Target_java_lang_ClassLoader parent;
    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private final ConcurrentHashMap<String, Target_java_lang_NamedPackage> packages = new ConcurrentHashMap();

    @Substitute
    public Target_java_lang_ClassLoader() {
        this.parent = null;
    }

    @Substitute
    public Target_java_lang_ClassLoader getParent() {
        return this.parent;
    }

    @Substitute
    public Target_java_lang_ClassLoader(Target_java_lang_ClassLoader parent) {
        this.parent = parent;
    }

    @Substitute
    private InputStream getResourceAsStream(String name) {
        return Target_java_lang_ClassLoader.getSystemResourceAsStream(name);
    }

    @Substitute
    private static InputStream getSystemResourceAsStream(String name) {
        List<byte[]> arr = Resources.get(name);
        return arr == null ? null : new ByteArrayInputStream(arr.get(0));
    }

    @Substitute
    private URL getResource(String name) {
        return Target_java_lang_ClassLoader.getSystemResource(name);
    }

    @Substitute
    private static URL getSystemResource(String name) {
        List<byte[]> arr = Resources.get(name);
        return arr == null ? null : Resources.createURL(name, arr.get(0));
    }

    @Substitute
    private Enumeration<URL> getResources(String name) {
        return Target_java_lang_ClassLoader.getSystemResources(name);
    }

    @Substitute
    private static Enumeration<URL> getSystemResources(String name) {
        List<byte[]> arr = Resources.get(name);
        if (arr == null) {
            return Collections.emptyEnumeration();
        }
        ArrayList<URL> res = new ArrayList<URL>(arr.size());
        for (byte[] data : arr) {
            res.add(Resources.createURL(name, data));
        }
        return Collections.enumeration(res);
    }

    @Substitute
    public static ClassLoader getSystemClassLoader() {
        return KnownIntrinsics.unsafeCast(JavaLangSubstitutions.ClassLoaderSupport.getInstance().systemClassLoader, ClassLoader.class);
    }

    @Substitute
    static void loadLibrary(Class<?> fromClass, String name, boolean isAbsolute) {
        NativeLibrarySupport.singleton().loadLibrary(name, isAbsolute);
    }

    @Substitute
    private Class<?> loadClass(String name) throws ClassNotFoundException {
        return ClassForNameSupport.forName(name);
    }

    @Substitute
    static void checkClassLoaderPermission(ClassLoader cl, Class<?> caller) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    public static ClassLoader getPlatformClassLoader() {
        throw VMError.unsupportedFeature("JDK9OrLater: Target_java_lang_ClassLoader.getPlatformClassLoader()");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    Class<?> loadClass(Target_java_lang_Module module, String name) {
        throw VMError.unsupportedFeature("JDK9OrLater: Target_java_lang_ClassLoader.loadClass(Target_java_lang_Module, String)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    ConcurrentHashMap<?, ?> createOrGetClassLoaderValueMap() {
        throw VMError.unsupportedFeature("JDK9OrLater: Target_java_lang_ClassLoader.createOrGetClassLoaderValueMap()");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private boolean trySetObjectField(String name, Object obj) {
        throw VMError.unsupportedFeature("JDK9OrLater: Target_java_lang_ClassLoader.trySetObjectField(String name, Object obj)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    protected URL findResource(String moduleName, String name) throws IOException {
        throw VMError.unsupportedFeature("JDK9OrLater: Target_java_lang_ClassLoader.findResource(String, String)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    static ClassLoader getBuiltinPlatformClassLoader() {
        throw VMError.unsupportedFeature("JDK9OrLater: Target_java_lang_ClassLoader.getBuiltinPlatformClassLoader()");
    }

    @Substitute
    Object getClassLoadingLock(String className) {
        throw VMError.unsupportedFeature("Target_java_lang_ClassLoader.getClassLoadingLock(String)");
    }

    @Substitute
    private Class<?> findLoadedClass0(String name) {
        throw VMError.unsupportedFeature("Target_java_lang_ClassLoader.findLoadedClass0(String)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    protected Class<?> findClass(String moduleName, String name) {
        throw VMError.unsupportedFeature("JDK9OrLater: Target_java_lang_ClassLoader.findClass(String moduleName, String name)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    public Package getDefinedPackage(String name) {
        throw VMError.unsupportedFeature("JDK9OrLater: Target_java_lang_ClassLoader.getDefinedPackage(String name)");
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK9OrLater.class})
    public native Package definePackage(Class<?> var1);

    @KeepOriginal
    @TargetElement(onlyWith={JDK9OrLater.class})
    public native Package definePackage(String var1, Target_java_lang_Module var2);

    @KeepOriginal
    @TargetElement(onlyWith={JDK9OrLater.class})
    private native Package toPackage(String var1, Target_java_lang_NamedPackage var2, Target_java_lang_Module var3);
}

