/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.util.ByteArrayReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;

public class ReferenceMapEncoder {
    private final HashMap<Input, Long> usageCounts = new HashMap();
    private final HashMap<Input, Long> encodings = new HashMap();
    private final UnsafeArrayTypeWriter writeBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());

    public void add(Input input) {
        if (input == null || input.isEmpty()) {
            return;
        }
        Long oldCount = this.usageCounts.get(input);
        Long newCount = oldCount == null ? 1L : oldCount + 1L;
        this.usageCounts.put(input, newCount);
    }

    public byte[] encodeAll(PinnedAllocator allocator) {
        assert (this.writeBuffer.getBytesWritten() == 0L) : "encodeAll() must not be called multiple times";
        assert (0L == this.writeBuffer.getBytesWritten());
        this.encodeEndOfTable();
        ArrayList<Map.Entry<Input, Long>> sortedEntries = new ArrayList<Map.Entry<Input, Long>>(this.usageCounts.entrySet());
        sortedEntries.sort((o1, o2) -> -Long.compare((Long)o1.getValue(), (Long)o2.getValue()));
        for (Map.Entry entry : sortedEntries) {
            Input map = (Input)entry.getKey();
            this.encodings.put(map, this.encode(map.getOffsets()));
        }
        int length = TypeConversion.asS4((long)this.writeBuffer.getBytesWritten());
        return this.writeBuffer.toArray(ReferenceMapEncoder.newByteArray(allocator, length));
    }

    private static byte[] newByteArray(PinnedAllocator allocator, int length) {
        return allocator == null ? new byte[length] : (byte[])allocator.newArray(Byte.TYPE, length);
    }

    public long lookupEncoding(Input referenceMap) {
        if (referenceMap == null) {
            return -1L;
        }
        if (referenceMap.isEmpty()) {
            return 0L;
        }
        Long result = this.encodings.get(referenceMap);
        assert (result != null && result != -1L && result != 0L);
        return result;
    }

    private long encode(OffsetIterator offsets) {
        int compressedSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        int uncompressedSize = FrameAccess.uncompressedReferenceSize();
        long startIndex = this.writeBuffer.getBytesWritten();
        int run = 0;
        int gap = 0;
        boolean expectedCompressed = false;
        int expectedOffset = 0;
        while (offsets.hasNext()) {
            int size;
            boolean compressed = offsets.isNextCompressed();
            boolean derived = offsets.isNextDerived();
            int offset = offsets.nextInt();
            if (offset == expectedOffset && compressed == expectedCompressed && !derived) {
                ++run;
            } else {
                assert (offset >= expectedOffset) : "values must be strictly increasing";
                if (run > 0) {
                    this.encodeRun(gap, run, expectedCompressed, false);
                }
                gap = offset - expectedOffset;
                run = 1;
            }
            int n = size = compressed ? compressedSize : uncompressedSize;
            if (derived) {
                this.encodeDerivedRun(gap, offset, offsets.getDerivedOffsets(offset), compressed, size);
                run = 0;
                gap = 0;
            }
            expectedOffset = offset + size;
            expectedCompressed = compressed;
        }
        if (run > 0) {
            this.encodeRun(gap, run, expectedCompressed, false);
        }
        this.encodeEndOfTable();
        return startIndex;
    }

    private void encodeRun(int gap, int refsCount, boolean compressed, boolean derived) {
        assert (gap >= 0 && refsCount >= 0);
        this.writeBuffer.putSV(derived ? (long)(-gap - 1) : (long)gap);
        this.writeBuffer.putSV(compressed ? (long)(-refsCount) : (long)refsCount);
    }

    private void encodeDerivedRun(int gap, int baseOffset, Set<Integer> derivedOffsets, boolean compressed, int size) {
        this.encodeRun(gap, derivedOffsets.size(), compressed, true);
        for (int derivedOffset : derivedOffsets) {
            assert (baseOffset % size == 0 && derivedOffset % size == 0 && derivedOffset != baseOffset);
            this.writeBuffer.putSV((long)((derivedOffset - baseOffset) / size));
        }
    }

    private void encodeEndOfTable() {
        this.encodeRun(0, 0, false, false);
    }

    public static interface Input {
        public boolean isEmpty();

        public OffsetIterator getOffsets();
    }

    public static interface OffsetIterator
    extends PrimitiveIterator.OfInt {
        @Override
        public boolean hasNext();

        @Override
        public int nextInt();

        public boolean isNextCompressed();

        public boolean isNextDerived();

        public Set<Integer> getDerivedOffsets(int var1);
    }
}

