/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.allocationprofile.AllocationCounter;
import com.oracle.svm.core.allocationprofile.AllocationSite;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.PinnedAllocatorImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.graal.jdk.SubstrateArraysCopyOfNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneNode;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.nodes.DimensionsNode;
import com.oracle.svm.core.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.graal.nodes.NewPinnedArrayNode;
import com.oracle.svm.core.graal.nodes.NewPinnedInstanceNode;
import com.oracle.svm.core.graal.nodes.SubstrateDynamicNewArrayNode;
import com.oracle.svm.core.graal.nodes.SubstrateDynamicNewInstanceNode;
import com.oracle.svm.core.graal.nodes.SubstrateNewArrayNode;
import com.oracle.svm.core.graal.nodes.SubstrateNewInstanceNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Map;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.PiArrayNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.PrefetchAllocateNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.ExplodeLoopNode;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.RuntimeReflection;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class AllocationSnippets
extends SubstrateTemplates
implements Snippets {
    public static final Object[] ALLOCATION_LOCATION_IDENTITIES = new Object[]{ThreadLocalAllocation.TOP_IDENTITY, ThreadLocalAllocation.END_IDENTITY, AllocationCounter.COUNT_FIELD, AllocationCounter.SIZE_FIELD, PinnedAllocatorImpl.OPEN_PINNED_ALLOCATOR_IDENTITY};
    private static final SnippetRuntime.SubstrateForeignCallDescriptor CHECK_DYNAMIC_HUB = SnippetRuntime.findForeignCall(AllocationSnippets.class, "checkDynamicHub", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor CHECK_ARRAY_HUB = SnippetRuntime.findForeignCall(AllocationSnippets.class, "checkArrayHub", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_INSTANCE = SnippetRuntime.findForeignCall(ThreadLocalAllocation.class, "slowPathNewInstance", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_ARRAY = SnippetRuntime.findForeignCall(ThreadLocalAllocation.class, "slowPathNewArray", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor NEW_MULTI_ARRAY = SnippetRuntime.findForeignCall(AllocationSnippets.class, "newMultiArray", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_PINNED_INSTANCE = SnippetRuntime.findForeignCall(PinnedAllocatorImpl.class, "slowPathNewInstance", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_PINNED_ARRAY = SnippetRuntime.findForeignCall(PinnedAllocatorImpl.class, "slowPathNewArray", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CHECK_DYNAMIC_HUB, CHECK_ARRAY_HUB, SLOW_NEW_INSTANCE, SLOW_NEW_ARRAY, NEW_MULTI_ARRAY, SLOW_NEW_PINNED_INSTANCE, SLOW_NEW_PINNED_ARRAY};
    private static final String runtimeReflectionTypeName = RuntimeReflection.class.getTypeName();
    private static final InstantiationException INSTANTIATION_EXCEPTION = new InstantiationException("Cannot allocate instance.");
    private static final IllegalArgumentException VOID_ARRAY = new IllegalArgumentException();
    private static final int sizeOfDimensionElement = ConfigurationValues.getObjectLayout().sizeInBytes(JavaKind.Int);
    private static final CloneNotSupportedException CLONE_NOT_SUPPORTED_EXCEPTION = new CloneNotSupportedException("Object is not instance of Cloneable.");

    public static Object newInstance(DynamicHub hub, int encoding, @Snippet.ConstantParameter boolean constantSize, @Snippet.ConstantParameter boolean fillContents, AllocationCounter counter) {
        AllocationSnippets.checkHub(hub);
        UnsignedWord size = LayoutEncoding.getInstanceSize(encoding);
        AllocationSnippets.profileAllocation(size, counter);
        Pointer memory = ThreadLocalAllocation.allocateMemory(ThreadLocalAllocation.regularTLAB.getAddress(), size);
        Object result = BranchProbabilityNode.probability((double)0.99, (boolean)memory.isNonNull()) ? AllocationSnippets.formatObjectImpl(memory, hub, size, constantSize, fillContents, false) : AllocationSnippets.callSlowNewInstance(SLOW_NEW_INSTANCE, DynamicHub.toClass(hub));
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    private static void checkHub(DynamicHub hub) {
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (hub == null || !hub.isInstantiated() ? 1 : 0) != 0)) {
            AllocationSnippets.callCheckDynamicHub(CHECK_DYNAMIC_HUB, DynamicHub.toClass(hub));
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callCheckDynamicHub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @SubstrateForeignCallTarget
    private static void checkDynamicHub(DynamicHub hub) {
        if (hub == null) {
            throw new NullPointerException("Allocation type is null.");
        }
        if (!hub.isInstantiated()) {
            throw new IllegalArgumentException("Class " + DynamicHub.toClass(hub).getTypeName() + " is instantiated reflectively but was never registered. Register the class by using " + runtimeReflectionTypeName);
        }
    }

    private static DynamicHub getCheckedArrayHub(DynamicHub elementType) {
        DynamicHub arrayHub = elementType.getArrayHub();
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (arrayHub == null || !arrayHub.isInstantiated() ? 1 : 0) != 0)) {
            AllocationSnippets.callCheckArrayHub(CHECK_ARRAY_HUB, DynamicHub.toClass(elementType));
        }
        return arrayHub;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callCheckArrayHub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @SubstrateForeignCallTarget
    private static void checkArrayHub(DynamicHub elementType) {
        throw new IllegalArgumentException("Class " + DynamicHub.toClass(elementType).getTypeName() + "[] is instantiated reflectively but was never registered. Register the class by using " + runtimeReflectionTypeName);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @Snippet
    public static Object staticNewInstanceSnippet(DynamicHub hub, @Snippet.ConstantParameter int encoding, @Snippet.ConstantParameter boolean fillContents, AllocationCounter counter) {
        return AllocationSnippets.newInstance(hub, encoding, true, fillContents, counter);
    }

    @Snippet
    public static Object dynamicNewInstanceSnippet(DynamicHub hub, @Snippet.ConstantParameter boolean fillContents, AllocationCounter counter) throws InstantiationException {
        if (!LayoutEncoding.isInstance(hub.getLayoutEncoding())) {
            throw INSTANTIATION_EXCEPTION;
        }
        return AllocationSnippets.newInstance(hub, hub.getLayoutEncoding(), false, fillContents, counter);
    }

    @Snippet
    public static Object newPinnedInstanceSnippet(PinnedAllocatorImpl pinnedAllocator, DynamicHub hub, @Snippet.ConstantParameter int encoding, @Snippet.ConstantParameter boolean fillContents, AllocationCounter counter) {
        pinnedAllocator.ensureOpen();
        UnsignedWord size = LayoutEncoding.getInstanceSize(encoding);
        AllocationSnippets.profileAllocation(size, counter);
        Pointer memory = ThreadLocalAllocation.allocateMemory(ThreadLocalAllocation.pinnedTLAB.getAddress(), size);
        Object result = BranchProbabilityNode.probability((double)0.99, (boolean)memory.isNonNull()) ? AllocationSnippets.formatObjectImpl(memory, hub, size, true, fillContents, false) : AllocationSnippets.callSlowNewPinnedInstance(SLOW_NEW_PINNED_INSTANCE, pinnedAllocator, DynamicHub.toClass(hub));
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewPinnedInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, PinnedAllocatorImpl var1, Class<?> var2);

    private static void profileAllocation(UnsignedWord size, AllocationCounter counter) {
        if (AllocationSite.Options.AllocationProfiling.getValue().booleanValue()) {
            counter.incrementCount();
            counter.incrementSize(size.rawValue());
        }
    }

    @Snippet
    public static Object newArraySnippet(DynamicHub hub, int length, @Snippet.ConstantParameter int layoutEncoding, @Snippet.ConstantParameter boolean fillContents, AllocationCounter counter) {
        AllocationSnippets.checkHub(hub);
        return AllocationSnippets.fastNewArrayWithPiCast(hub, length, layoutEncoding, fillContents, counter);
    }

    private static Object fastNewArrayWithPiCast(DynamicHub hub, int length, @Snippet.ConstantParameter int layoutEncoding, @Snippet.ConstantParameter boolean fillContents, AllocationCounter counter) {
        Object result = AllocationSnippets.fastNewArray(hub, length, layoutEncoding, fillContents, counter);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)result, (int)length);
    }

    public static Object fastNewArray(DynamicHub hub, int length, int layoutEncoding, boolean fillContents, AllocationCounter counter) {
        UnsignedWord size = LayoutEncoding.getArraySize(layoutEncoding, length);
        AllocationSnippets.profileAllocation(size, counter);
        Object result = AllocationSnippets.fastNewArrayUninterruptibly(hub, length, layoutEncoding, fillContents, size);
        if (result == null) {
            result = AllocationSnippets.callSlowNewArray(SLOW_NEW_ARRAY, DynamicHub.toClass(hub), length);
        }
        return result;
    }

    @Uninterruptible(reason="Holds uninitialized memory from allocateMemory through formatArryImpl")
    private static Object fastNewArrayUninterruptibly(DynamicHub hub, int length, int layoutEncoding, boolean fillContents, UnsignedWord size) {
        Pointer memory = (Pointer)WordFactory.nullPointer();
        if (size.belowOrEqual(HeapPolicy.getLargeArrayThreshold()) && length >= 0) {
            memory = ThreadLocalAllocation.allocateMemory(ThreadLocalAllocation.regularTLAB.getAddress(), size);
        }
        Object result = null;
        if (memory.isNonNull()) {
            result = AllocationSnippets.formatArrayImpl(memory, hub, length, layoutEncoding, size, fillContents, false, false);
        }
        return result;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1, int var2);

    @Snippet
    public static Object dynamicNewArraySnippet(DynamicHub elementType, int length, @Snippet.ConstantParameter boolean fillContents, AllocationCounter counter) {
        if (elementType == DynamicHub.fromClass(Void.TYPE)) {
            throw VOID_ARRAY;
        }
        DynamicHub hub = AllocationSnippets.getCheckedArrayHub(elementType);
        return AllocationSnippets.fastNewArrayWithPiCast(hub, length, hub.getLayoutEncoding(), fillContents, counter);
    }

    @Snippet
    public static Object newPinnedArraySnippet(PinnedAllocatorImpl pinnedAllocator, DynamicHub hub, int length, @Snippet.ConstantParameter int layoutEncoding, @Snippet.ConstantParameter boolean fillContents, AllocationCounter counter) {
        pinnedAllocator.ensureOpen();
        UnsignedWord size = LayoutEncoding.getArraySize(layoutEncoding, length);
        AllocationSnippets.profileAllocation(size, counter);
        Pointer memory = (Pointer)WordFactory.nullPointer();
        if (size.belowOrEqual(HeapPolicy.getLargeArrayThreshold()) && length >= 0) {
            memory = ThreadLocalAllocation.allocateMemory(ThreadLocalAllocation.pinnedTLAB.getAddress(), size);
        }
        Object result = null;
        result = BranchProbabilityNode.probability((double)0.99, (boolean)memory.isNonNull()) ? AllocationSnippets.formatArrayImpl(memory, hub, length, layoutEncoding, size, fillContents, false, false) : AllocationSnippets.callSlowNewPinnedArray(SLOW_NEW_PINNED_ARRAY, pinnedAllocator, DynamicHub.toClass(hub), length);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)result, (int)length);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callSlowNewPinnedArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, PinnedAllocatorImpl var1, Class<?> var2, int var3);

    @Snippet
    public static Object formatObjectSnippet(Word memory, DynamicHub hub, boolean rememberedSet) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        UnsignedWord size = LayoutEncoding.getInstanceSize(hubNonNull.getLayoutEncoding());
        return AllocationSnippets.formatObjectImpl((Pointer)memory, hubNonNull, size, false, true, rememberedSet);
    }

    @Snippet
    public static Object formatArraySnippet(Word memory, DynamicHub hub, int length, boolean rememberedSet, boolean unaligned) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getArraySize(layoutEncoding, length);
        AllocationSnippets.emitPrefetchAllocate((Pointer)memory, true);
        return AllocationSnippets.formatArrayImpl((Pointer)memory, hubNonNull, length, layoutEncoding, size, true, rememberedSet, unaligned);
    }

    @Snippet
    public static Object newMultiArraySnippet(DynamicHub hub, @Snippet.ConstantParameter int rank, @Snippet.VarargsParameter int[] dimensions, AllocationCounter counter) {
        Pointer dims = DimensionsNode.allocaDimsArray(rank);
        ExplodeLoopNode.explodeLoop();
        for (int i = 0; i < rank; ++i) {
            dims.writeInt(i * sizeOfDimensionElement, dimensions[i], LocationIdentity.INIT_LOCATION);
        }
        return AllocationSnippets.callNewMultiArray(NEW_MULTI_ARRAY, DynamicHub.toClass(hub), rank, dims, counter);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callNewMultiArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1, int var2, Pointer var3, AllocationCounter var4);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    @SubstrateForeignCallTarget
    private static Object newMultiArray(DynamicHub hub, int rank, Pointer dimensionsStackValue, AllocationCounter counter) {
        for (int i = 0; i < rank; ++i) {
            if (dimensionsStackValue.readInt(i * sizeOfDimensionElement) >= 0) continue;
            throw new NegativeArraySizeException();
        }
        return AllocationSnippets.newMultiArrayRecursion(hub, rank, dimensionsStackValue, counter);
    }

    private static Object newMultiArrayRecursion(DynamicHub hub, int rank, Pointer dimensionsStackValue, AllocationCounter counter) {
        AllocationSnippets.checkHub(hub);
        int length = dimensionsStackValue.readInt(0);
        Object result = AllocationSnippets.fastNewArray(hub, length, hub.getLayoutEncoding(), true, counter);
        if (rank > 1) {
            UnsignedWord offset = LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding());
            UnsignedWord endOffset = LayoutEncoding.getArrayElementOffset(hub.getLayoutEncoding(), length);
            while (offset.belowThan(endOffset)) {
                BarrieredAccess.writeObject((Object)result, (WordBase)offset, (Object)AllocationSnippets.newMultiArrayRecursion(hub.getComponentHub(), rank - 1, dimensionsStackValue.add(sizeOfDimensionElement), counter));
                offset = offset.add(ConfigurationValues.getObjectLayout().getReferenceSize());
            }
        }
        return result;
    }

    @Snippet
    public static Object arraysCopyOfSnippet(DynamicHub hub, Object original, int originalLength, int newLength, AllocationCounter counter) {
        AllocationSnippets.checkHub(hub);
        int layoutEncoding = hub.getLayoutEncoding();
        Object newArray = AllocationSnippets.fastNewArrayWithPiCast(hub, newLength, layoutEncoding, false, counter);
        int copiedLength = originalLength < newLength ? originalLength : newLength;
        UnsignedWord copiedEndOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, copiedLength);
        UnsignedWord newArrayEndOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, newLength);
        UnsignedWord offset = LayoutEncoding.getArrayBaseOffset(layoutEncoding);
        while (offset.belowThan(copiedEndOffset)) {
            Object val = ObjectAccess.readObject((Object)original, (WordBase)offset);
            ObjectAccess.writeObject((Object)newArray, (WordBase)offset, (Object)val, (LocationIdentity)LocationIdentity.INIT_LOCATION);
            offset = offset.add(ConfigurationValues.getObjectLayout().getReferenceSize());
        }
        while (offset.belowThan(newArrayEndOffset)) {
            ObjectAccess.writeObject((Object)newArray, (WordBase)offset, null, (LocationIdentity)LocationIdentity.INIT_LOCATION);
            offset = offset.add(ConfigurationValues.getObjectLayout().getReferenceSize());
        }
        return FixedValueAnchorNode.getObject((Object)newArray);
    }

    @Snippet
    private static Object doCloneSnippet(Object thisObj, AllocationCounter counter) throws CloneNotSupportedException {
        if (!(thisObj instanceof Cloneable)) {
            throw CLONE_NOT_SUPPORTED_EXCEPTION;
        }
        DynamicHub hub = KnownIntrinsics.readHub(thisObj);
        int layoutEncoding = hub.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getSizeFromObject(thisObj);
        AllocationSnippets.profileAllocation(size, counter);
        Pointer memory = ThreadLocalAllocation.allocateMemory(ThreadLocalAllocation.regularTLAB.getAddress(), size);
        Object thatObject = null;
        if (BranchProbabilityNode.probability((double)0.99, (boolean)memory.isNonNull())) {
            WordBase header = ObjectHeaderImpl.getObjectHeaderImpl().formatHub(hub, false, false);
            ObjectHeader.initializeHeaderOfNewObject(memory, header);
            thatObject = memory.toObjectNonNull();
        } else if (LayoutEncoding.isArray(layoutEncoding)) {
            int length = KnownIntrinsics.readArrayLength(thisObj);
            thatObject = AllocationSnippets.callSlowNewArray(SLOW_NEW_ARRAY, DynamicHub.toClass(hub), length);
        } else {
            thatObject = AllocationSnippets.callSlowNewInstance(SLOW_NEW_INSTANCE, DynamicHub.toClass(hub));
        }
        if (LayoutEncoding.isArray(layoutEncoding)) {
            int length = KnownIntrinsics.readArrayLength(thisObj);
            thatObject = PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)thatObject, (int)length);
        } else {
            thatObject = PiNode.piCastToSnippetReplaceeStamp((Object)thatObject);
        }
        UnsignedWord firstFieldOffset = (UnsignedWord)WordFactory.signed((int)ConfigurationValues.getObjectLayout().getFirstFieldOffset());
        return AllocationSnippets.doCloneUninterruptibly(thisObj, thatObject, firstFieldOffset, size);
    }

    @Uninterruptible(reason="Copies via Pointers")
    private static Object doCloneUninterruptibly(Object thisObject, Object thatObject, UnsignedWord firstFieldOffset, UnsignedWord size) {
        Word thatMemory = Word.objectToUntrackedPointer((Object)thatObject);
        Word thisMemory = Word.objectToUntrackedPointer((Object)thisObject);
        UnsignedWord offset = firstFieldOffset;
        if (!AllocationSnippets.isWordAligned(offset) && offset.belowThan(size)) {
            thatMemory.writeInt((WordBase)offset, thisMemory.readInt((WordBase)offset));
            offset = offset.add(4);
        }
        while (offset.belowThan(size)) {
            thatMemory.writeWord((WordBase)offset, thisMemory.readWord((WordBase)offset));
            offset = offset.add(ConfigurationValues.getTarget().wordSize);
        }
        return thatMemory.toObjectNonNull();
    }

    private static Object formatObjectImpl(Pointer memory, DynamicHub hub, UnsignedWord size, @Snippet.ConstantParameter boolean constantSize, @Snippet.ConstantParameter boolean fillContents, boolean rememberedSet) {
        if (fillContents) {
            AllocationSnippets.emitPrefetchAllocate(memory, false);
        }
        WordBase header = ObjectHeaderImpl.getObjectHeaderImpl().formatHub(hub, rememberedSet, false);
        ObjectHeaderImpl.initializeHeaderOfNewObject(memory, header);
        if (fillContents) {
            int wordSize = ConfigurationValues.getTarget().wordSize;
            UnsignedWord offset = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getFirstFieldOffset());
            Word zeroingStores = (Word)WordFactory.zero();
            if (!AllocationSnippets.isWordAligned(offset) && offset.belowThan(size)) {
                memory.writeInt((WordBase)offset, 0, LocationIdentity.INIT_LOCATION);
                offset = offset.add(4);
                zeroingStores = zeroingStores.add(1);
            }
            if (constantSize && (zeroingStores = zeroingStores.add(size.subtract(offset).unsignedDivide(wordSize))).belowOrEqual(SubstrateOptions.MaxUnrolledObjectZeroingStores.getValue().intValue())) {
                ExplodeLoopNode.explodeLoop();
            }
            while (offset.belowThan(size)) {
                memory.writeWord((WordBase)offset, WordFactory.zero(), LocationIdentity.INIT_LOCATION);
                offset = offset.add(wordSize);
            }
        }
        return memory.toObjectNonNull();
    }

    private static void emitPrefetchAllocate(Pointer address, boolean isArray) {
        if (SubstrateOptions.AllocatePrefetchStyle.getValue() > 0) {
            int lines = isArray ? SubstrateOptions.AllocatePrefetchLines.getValue().intValue() : SubstrateOptions.AllocateInstancePrefetchLines.getValue().intValue();
            int stepSize = SubstrateOptions.AllocatePrefetchStepSize.getValue();
            int distance = SubstrateOptions.AllocatePrefetchDistance.getValue();
            ExplodeLoopNode.explodeLoop();
            for (int i = 0; i < lines; ++i) {
                PrefetchAllocateNode.prefetch((AddressNode.Address)OffsetAddressNode.address((Object)address, (long)distance));
                distance += stepSize;
            }
        }
    }

    @Uninterruptible(reason="Manipulates Objects via Pointers", callerMustBe=true)
    private static Object formatArrayImpl(Pointer memory, DynamicHub hub, int length, int layoutEncoding, UnsignedWord size, boolean fillContents, boolean rememberedSet, boolean unaligned) {
        WordBase header = ObjectHeaderImpl.getObjectHeaderImpl().formatHub(hub, rememberedSet, unaligned);
        ObjectHeader.initializeHeaderOfNewObject(memory, header);
        memory.writeInt(ConfigurationValues.getObjectLayout().getArrayLengthOffset(), length, LocationIdentity.INIT_LOCATION);
        if (fillContents) {
            UnsignedWord offset = LayoutEncoding.getArrayBaseOffset(layoutEncoding);
            if (!AllocationSnippets.isWordAligned(offset) && offset.belowThan(size)) {
                memory.writeInt((WordBase)offset, 0, LocationIdentity.INIT_LOCATION);
                offset = offset.add(4);
            }
            while (offset.belowThan(size)) {
                memory.writeWord((WordBase)offset, WordFactory.zero(), LocationIdentity.INIT_LOCATION);
                offset = offset.add(ConfigurationValues.getTarget().wordSize);
            }
        }
        return memory.toObjectNonNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    private static boolean isWordAligned(UnsignedWord offset) {
        return offset.unsignedRemainder(ConfigurationValues.getTarget().wordSize).equal(0);
    }

    public static void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> foreignCalls, boolean hosted) {
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : FOREIGN_CALLS) {
            foreignCalls.put(descriptor, new SubstrateForeignCallLinkage(providers, descriptor));
        }
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new AllocationSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    private AllocationSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        NewInstanceLowering newInstanceLowering = new NewInstanceLowering();
        lowerings.put(NewInstanceNode.class, newInstanceLowering);
        lowerings.put(SubstrateNewInstanceNode.class, newInstanceLowering);
        DynamicNewInstanceLowering dynamicNewInstanceLowering = new DynamicNewInstanceLowering();
        lowerings.put(DynamicNewInstanceNode.class, dynamicNewInstanceLowering);
        lowerings.put(SubstrateDynamicNewInstanceNode.class, dynamicNewInstanceLowering);
        NewArrayLowering newArrayLowering = new NewArrayLowering();
        lowerings.put(NewArrayNode.class, newArrayLowering);
        lowerings.put(SubstrateNewArrayNode.class, newArrayLowering);
        DynamicNewArrayLowering dynamicNewArrayLowering = new DynamicNewArrayLowering();
        lowerings.put(DynamicNewArrayNode.class, dynamicNewArrayLowering);
        lowerings.put(SubstrateDynamicNewArrayNode.class, dynamicNewArrayLowering);
        NewMultiArrayLowering newMultiArrayLowering = new NewMultiArrayLowering();
        lowerings.put(NewMultiArrayNode.class, newMultiArrayLowering);
        lowerings.put(NewPinnedInstanceNode.class, new NewPinnedInstanceLowering());
        lowerings.put(NewPinnedArrayNode.class, new NewPinnedArrayLowering());
        lowerings.put(FormatObjectNode.class, new FormatObjectLowering());
        lowerings.put(FormatArrayNode.class, new FormatArrayLowering());
        ArraysCopyOfLowering arraysCopyOfLowering = new ArraysCopyOfLowering();
        lowerings.put(SubstrateArraysCopyOfNode.class, arraysCopyOfLowering);
        ObjectCloneLowering objectCloneLowering = new ObjectCloneLowering();
        lowerings.put(SubstrateObjectCloneNode.class, objectCloneLowering);
    }

    public static void addCounterArgs(SnippetTemplate.Arguments args, ValueNode node, ResolvedJavaType type) {
        AllocationCounter counter = null;
        if (AllocationSite.Options.AllocationProfiling.getValue().booleanValue()) {
            String siteName = "[others]";
            if (node.getNodeSourcePosition() != null) {
                siteName = node.getNodeSourcePosition().getMethod().asStackTraceElement(node.getNodeSourcePosition().getBCI()).toString();
            }
            String className = "[dynamic]";
            if (type != null) {
                className = type.toJavaName(true);
            }
            AllocationSite allocationSite = AllocationSite.lookup(siteName, className);
            String counterName = node.graph().name;
            if (counterName == null) {
                counterName = node.graph().method().format("%H.%n(%p)");
            }
            counter = allocationSite.createCounter(counterName);
        }
        args.add("counter", counter);
    }

    final class ObjectCloneLowering
    implements NodeLoweringProvider<SubstrateObjectCloneNode> {
        private final SnippetTemplate.SnippetInfo doClone;

        ObjectCloneLowering() {
            this.doClone = AllocationSnippets.this.snippet(AllocationSnippets.class, "doCloneSnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(SubstrateObjectCloneNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.doClone, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("thisObj", (Object)node.getObject());
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, null);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class ArraysCopyOfLowering
    implements NodeLoweringProvider<SubstrateArraysCopyOfNode> {
        private final SnippetTemplate.SnippetInfo arraysCopyOf;

        protected ArraysCopyOfLowering() {
            this.arraysCopyOf = AllocationSnippets.this.snippet(AllocationSnippets.class, "arraysCopyOfSnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(SubstrateArraysCopyOfNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.arraysCopyOf, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("hub", (Object)node.getNewArrayType());
            args.add("original", (Object)node.getOriginal());
            args.add("originalLength", (Object)node.getOriginaLength());
            args.add("newLength", (Object)node.getNewLength());
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, null);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class NewMultiArrayLowering
    implements NodeLoweringProvider<NewMultiArrayNode> {
        private final SnippetTemplate.SnippetInfo newMultiArray;

        protected NewMultiArrayLowering() {
            this.newMultiArray = AllocationSnippets.this.snippet(AllocationSnippets.class, "newMultiArraySnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(NewMultiArrayNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            StructuredGraph graph = node.graph();
            int rank = node.dimensionCount();
            ValueNode[] dims = new ValueNode[rank];
            for (int i = 0; i < node.dimensionCount(); ++i) {
                dims[i] = node.dimension(i);
            }
            SharedType type = (SharedType)node.type();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.newMultiArray, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("hub", (Object)type.getHub());
            args.addConst("rank", (Object)rank);
            args.addVarargs("dimensions", Integer.TYPE, StampFactory.forKind((JavaKind)JavaKind.Int), (Object)dims);
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, type);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class FormatArrayLowering
    implements NodeLoweringProvider<FormatArrayNode> {
        private final SnippetTemplate.SnippetInfo formatArray;

        protected FormatArrayLowering() {
            this.formatArray = AllocationSnippets.this.snippet(AllocationSnippets.class, "formatArraySnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(FormatArrayNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.formatArray, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("memory", (Object)node.getMemory());
            args.add("hub", (Object)node.getHub());
            args.add("length", (Object)node.getLength());
            args.add("rememberedSet", (Object)node.getRememberedSet());
            args.add("unaligned", (Object)node.getUnaligned());
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class FormatObjectLowering
    implements NodeLoweringProvider<FormatObjectNode> {
        private final SnippetTemplate.SnippetInfo formatObject;

        protected FormatObjectLowering() {
            this.formatObject = AllocationSnippets.this.snippet(AllocationSnippets.class, "formatObjectSnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(FormatObjectNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.formatObject, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("memory", (Object)node.getMemory());
            args.add("hub", (Object)node.getHub());
            args.add("rememberedSet", (Object)node.getRememberedSet());
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class NewPinnedArrayLowering
    implements NodeLoweringProvider<NewPinnedArrayNode> {
        private final SnippetTemplate.SnippetInfo newPinnedArray;

        protected NewPinnedArrayLowering() {
            this.newPinnedArray = AllocationSnippets.this.snippet(AllocationSnippets.class, "newPinnedArraySnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(NewPinnedArrayNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SharedType type = (SharedType)node.elementType().getArrayClass();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.newPinnedArray, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("pinnedAllocator", (Object)node.getPinnedAllocator());
            args.add("hub", (Object)type.getHub());
            args.add("length", (Object)node.length());
            args.addConst("layoutEncoding", (Object)type.getHub().getLayoutEncoding());
            args.addConst("fillContents", (Object)node.fillContents());
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, type);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class NewPinnedInstanceLowering
    implements NodeLoweringProvider<NewPinnedInstanceNode> {
        private final SnippetTemplate.SnippetInfo newPinnedInstance;

        protected NewPinnedInstanceLowering() {
            this.newPinnedInstance = AllocationSnippets.this.snippet(AllocationSnippets.class, "newPinnedInstanceSnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(NewPinnedInstanceNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SharedType type = (SharedType)node.instanceClass();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.newPinnedInstance, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("pinnedAllocator", (Object)node.getPinnedAllocator());
            args.add("hub", (Object)ConstantNode.forConstant((Stamp)StampFactory.objectNonNull(), (Constant)SubstrateObjectConstant.forObject(type.getHub()), (MetaAccessProvider)AllocationSnippets.this.providers.getMetaAccess(), (StructuredGraph)node.graph()));
            args.addConst("encoding", (Object)type.getHub().getLayoutEncoding());
            args.addConst("fillContents", (Object)node.fillContents());
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, type);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class DynamicNewArrayLowering
    implements NodeLoweringProvider<DynamicNewArrayNode> {
        private final SnippetTemplate.SnippetInfo dynamicNewArray;

        protected DynamicNewArrayLowering() {
            this.dynamicNewArray = AllocationSnippets.this.snippet(AllocationSnippets.class, "dynamicNewArraySnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(DynamicNewArrayNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.dynamicNewArray, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("elementType", (Object)node.getElementType());
            args.add("length", (Object)node.length());
            args.addConst("fillContents", (Object)node.fillContents());
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, null);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class NewArrayLowering
    implements NodeLoweringProvider<NewArrayNode> {
        private final SnippetTemplate.SnippetInfo newArray;

        protected NewArrayLowering() {
            this.newArray = AllocationSnippets.this.snippet(AllocationSnippets.class, "newArraySnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(NewArrayNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SharedType type = (SharedType)node.elementType().getArrayClass();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.newArray, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("hub", (Object)type.getHub());
            args.add("length", (Object)node.length());
            args.addConst("layoutEncoding", (Object)type.getHub().getLayoutEncoding());
            args.addConst("fillContents", (Object)node.fillContents());
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, type);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class DynamicNewInstanceLowering
    implements NodeLoweringProvider<DynamicNewInstanceNode> {
        private final SnippetTemplate.SnippetInfo dynamicNewInstance;

        protected DynamicNewInstanceLowering() {
            this.dynamicNewInstance = AllocationSnippets.this.snippet(AllocationSnippets.class, "dynamicNewInstanceSnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(DynamicNewInstanceNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.dynamicNewInstance, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("hub", (Object)node.getInstanceType());
            args.addConst("fillContents", (Object)node.fillContents());
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, null);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class NewInstanceLowering
    implements NodeLoweringProvider<NewInstanceNode> {
        private final SnippetTemplate.SnippetInfo newInstance;

        protected NewInstanceLowering() {
            this.newInstance = AllocationSnippets.this.snippet(AllocationSnippets.class, "staticNewInstanceSnippet", ALLOCATION_LOCATION_IDENTITIES);
        }

        @Override
        public void lower(NewInstanceNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SharedType type = (SharedType)node.instanceClass();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.newInstance, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("hub", (Object)type.getHub());
            args.addConst("encoding", (Object)type.getHub().getLayoutEncoding());
            args.addConst("fillContents", (Object)node.fillContents());
            AllocationSnippets.addCounterArgs(args, (ValueNode)node, type);
            AllocationSnippets.this.template((ValueNode)node, args).instantiate(AllocationSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

