/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.util.AtomicUnsigned;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class HeapPolicy {
    static final long LARGE_ARRAY_THRESHOLD_SENTINEL_VALUE = 0L;
    private static final int ALIGNED_HEAP_CHUNK_FRACTION_FOR_LARGE_ARRAY_THRESHOLD = 8;
    private final CollectOnAllocationPolicy collectOnAllocationPolicy;
    private final HintGCPolicy userRequestedGCPolicy;
    private static UnsignedWord maximumYoungGenerationSize;
    private static UnsignedWord minimumHeapSize;
    private static UnsignedWord maximumHeapSize;
    private static final UnsignedWord producedHeapChunkZapInt;
    private static final UnsignedWord producedHeapChunkZapWord;
    private static final UnsignedWord consumedHeapChunkZapInt;
    private static final UnsignedWord consumedHeapChunkZapWord;
    static final AtomicUnsigned bytesAllocatedSinceLastCollection;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected HeapPolicy(Feature.FeatureAccess access) {
        if (!SubstrateUtil.isPowerOf2(HeapPolicy.getAlignedHeapChunkSize().rawValue())) {
            throw UserError.abort("AlignedHeapChunkSize (" + HeapPolicy.getAlignedHeapChunkSize().rawValue() + ") should be a power of 2.");
        }
        if (!HeapPolicy.getLargeArrayThreshold().belowOrEqual(HeapPolicy.getAlignedHeapChunkSize())) {
            throw UserError.abort("LargeArrayThreshold (" + HeapPolicy.getLargeArrayThreshold().rawValue() + ") should be below or equal to AlignedHeapChunkSize (" + HeapPolicy.getAlignedHeapChunkSize().rawValue() + ").");
        }
        this.userRequestedGCPolicy = HeapPolicy.instantiatePolicy(access, HintGCPolicy.class, HeapPolicyOptions.UserRequestedGCPolicy.getValue());
        this.collectOnAllocationPolicy = CollectOnAllocationPolicy.Sometimes.factory();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static <T> T instantiatePolicy(Feature.FeatureAccess access, Class<T> policyClass, String className) {
        Object result;
        Class policy = access.findClassByName(className);
        if (policy == null) {
            throw UserError.abort("policy " + className + " does not exist. It must be a fully qualified class name.");
        }
        try {
            result = policy.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw UserError.abort("policy " + className + " cannot be instantiated.");
        }
        if (!policyClass.isInstance(result)) {
            throw UserError.abort("policy " + className + " does not extend " + policyClass.getTypeName() + ".");
        }
        return policyClass.cast(result);
    }

    CollectOnAllocationPolicy getCollectOnAllocationPolicy() {
        return this.collectOnAllocationPolicy;
    }

    public static Word getProducedHeapChunkZapWord() {
        return (Word)producedHeapChunkZapWord;
    }

    public static int getProducedHeapChunkZapInt() {
        return (int)producedHeapChunkZapInt.rawValue();
    }

    public static Word getConsumedHeapChunkZapWord() {
        return (Word)consumedHeapChunkZapWord;
    }

    public static int getConsumedHeapChunkZapInt() {
        return (int)consumedHeapChunkZapInt.rawValue();
    }

    public static UnsignedWord k(int bytes) {
        assert (0 <= bytes);
        return HeapPolicy.k((long)bytes);
    }

    public static UnsignedWord k(long bytes) {
        assert (0L <= bytes);
        return HeapPolicy.k(WordFactory.unsigned((long)bytes));
    }

    public static UnsignedWord k(UnsignedWord bytes) {
        return bytes.multiply(1024);
    }

    public static UnsignedWord m(int bytes) {
        assert (0 <= bytes);
        return HeapPolicy.m((long)bytes);
    }

    public static UnsignedWord m(long bytes) {
        assert (0L <= bytes);
        return HeapPolicy.m(WordFactory.unsigned((long)bytes));
    }

    public static UnsignedWord m(UnsignedWord bytes) {
        return HeapPolicy.k(HeapPolicy.k(bytes));
    }

    public static UnsignedWord g(int bytes) {
        assert (0 <= bytes);
        return HeapPolicy.g((long)bytes);
    }

    public static UnsignedWord g(long bytes) {
        assert (0L <= bytes);
        return HeapPolicy.g(WordFactory.unsigned((long)bytes));
    }

    public static UnsignedWord g(UnsignedWord bytes) {
        return HeapPolicy.k(HeapPolicy.k(HeapPolicy.k(bytes)));
    }

    private static int getMaximumHeapSizePercent() {
        int result = HeapPolicyOptions.MaximumHeapSizePercent.getValue();
        VMError.guarantee(result >= 0 && result <= 100, "MaximumHeapSizePercent should be in [0 ..100]");
        return result;
    }

    private static int getMaximumYoungGenerationSizePercent() {
        int result = HeapPolicyOptions.MaximumYoungGenerationSizePercent.getValue();
        VMError.guarantee(result >= 0 && result <= 100, "MaximumYoungGenerationSizePercent should be in [0 ..100]");
        return result;
    }

    private static UnsignedWord getAllocationBeforePhysicalMemorySize() {
        return WordFactory.unsigned((long)HeapPolicyOptions.AllocationBeforePhysicalMemorySize.getValue());
    }

    public static UnsignedWord getMaximumYoungGenerationSize() {
        UnsignedWord maxSize;
        Log trace = Log.noopLog().string("[HeapPolicy.getMaximumYoungGenerationSize:");
        if (maximumYoungGenerationSize.aboveThan((UnsignedWord)WordFactory.zero())) {
            trace.string("  returns maximumYoungGenerationSize: ").unsigned((WordBase)maximumYoungGenerationSize).string(" ]").newline();
            return maximumYoungGenerationSize;
        }
        XOptions.XFlag xmn = XOptions.getXmn();
        if (xmn.getEpoch() > 0L) {
            trace.string("  -Xmn.epoch: ").unsigned(xmn.getEpoch()).string("  -Xmn.value: ").unsigned(xmn.getValue());
            HeapPolicy.setMaximumYoungGenerationSize(WordFactory.unsigned((long)xmn.getValue()));
            trace.string("  returns: ").unsigned((WordBase)maximumYoungGenerationSize).string(" ]").newline();
            return maximumYoungGenerationSize;
        }
        UnsignedWord maxHeapSize = HeapPolicy.getMaximumHeapSize();
        UnsignedWord youngSizeAsFraction = maxHeapSize.unsignedDivide(100).multiply(HeapPolicy.getMaximumYoungGenerationSizePercent());
        UnsignedWord youngSize = youngSizeAsFraction.belowOrEqual(maxSize = HeapPolicy.m(256)) ? youngSizeAsFraction : maxSize;
        trace.string("  youngSize: ").unsigned((WordBase)youngSize).string(" ]").newline();
        return youngSize;
    }

    public static UnsignedWord setMaximumYoungGenerationSize(UnsignedWord value) {
        UnsignedWord result = maximumYoungGenerationSize;
        maximumYoungGenerationSize = value;
        return result;
    }

    public static UnsignedWord getMaximumHeapSize() {
        if (maximumHeapSize.aboveThan((UnsignedWord)WordFactory.zero())) {
            return maximumHeapSize;
        }
        XOptions.XFlag xmx = XOptions.getXmx();
        if (xmx.getEpoch() > 0L) {
            HeapPolicy.setMaximumHeapSize(WordFactory.unsigned((long)xmx.getValue()));
            return maximumHeapSize;
        }
        if (PhysicalMemory.hasSize()) {
            UnsignedWord physicalMemorySize = PhysicalMemory.size();
            int maximumHeapSizePercent = HeapPolicy.getMaximumHeapSizePercent();
            UnsignedWord sizeFromPercent = physicalMemorySize.unsignedDivide(100).multiply(maximumHeapSizePercent);
            return sizeFromPercent;
        }
        return UnsignedUtils.MAX_VALUE;
    }

    public static UnsignedWord setMaximumHeapSize(UnsignedWord value) {
        Log trace = Log.noopLog().string("[HeapPolicy.setMaximumHeapSize:");
        UnsignedWord result = maximumHeapSize;
        maximumHeapSize = value;
        trace.string("  old: ").unsigned((WordBase)result).string("  new: ").unsigned((WordBase)maximumHeapSize).string(" ]").newline();
        return result;
    }

    public static UnsignedWord getMinimumHeapSize() {
        Log trace = Log.noopLog().string("[HeapPolicy.getMinimumHeapSize:");
        if (minimumHeapSize.aboveThan((UnsignedWord)WordFactory.zero())) {
            trace.string("  returns: ").unsigned((WordBase)minimumHeapSize).string(" ]").newline();
            return minimumHeapSize;
        }
        XOptions.XFlag xms = XOptions.getXms();
        if (xms.getEpoch() > 0L) {
            trace.string("  -Xms.epoch: ").unsigned(xms.getEpoch()).string("  -Xms.value: ").unsigned(xms.getValue());
            HeapPolicy.setMinimumHeapSize(WordFactory.unsigned((long)xms.getValue()));
            trace.string("  returns: ").unsigned((WordBase)minimumHeapSize).string(" ]").newline();
            return minimumHeapSize;
        }
        UnsignedWord result = HeapPolicy.getMaximumYoungGenerationSize().multiply(2);
        if (result.aboveThan(HeapPolicy.getMaximumHeapSize())) {
            result = HeapPolicy.getMaximumHeapSize();
        }
        trace.string("  returns: ").unsigned((WordBase)result).string(" ]").newline();
        return result;
    }

    public static UnsignedWord setMinimumHeapSize(UnsignedWord value) {
        UnsignedWord result = minimumHeapSize;
        minimumHeapSize = value;
        return result;
    }

    @Fold
    public static UnsignedWord getAlignedHeapChunkSize() {
        return WordFactory.unsigned((long)HeapPolicyOptions.AlignedHeapChunkSize.getValue());
    }

    @Fold
    static UnsignedWord getAlignedHeapChunkAlignment() {
        return HeapPolicy.getAlignedHeapChunkSize();
    }

    @Fold
    public static UnsignedWord getLargeArrayThreshold() {
        long largeArrayThreshold = HeapPolicyOptions.LargeArrayThreshold.getValue();
        if (0L == largeArrayThreshold) {
            return HeapPolicy.getAlignedHeapChunkSize().unsignedDivide(8);
        }
        return WordFactory.unsigned((long)HeapPolicyOptions.LargeArrayThreshold.getValue());
    }

    public static boolean getZapProducedHeapChunks() {
        return HeapPolicyOptions.ZapChunks.getValue() != false || HeapPolicyOptions.ZapProducedHeapChunks.getValue() != false;
    }

    public static boolean getZapConsumedHeapChunks() {
        return HeapPolicyOptions.ZapChunks.getValue() != false || HeapPolicyOptions.ZapConsumedHeapChunks.getValue() != false;
    }

    static UnsignedWord getBytesAllocatedSinceLastCollection() {
        return (UnsignedWord)bytesAllocatedSinceLastCollection.get();
    }

    static void samplePhysicalMemorySize() {
        if (HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch().equal((UnsignedWord)WordFactory.zero()) && HeapPolicy.getBytesAllocatedSinceLastCollection().aboveThan(HeapPolicy.getAllocationBeforePhysicalMemorySize())) {
            PhysicalMemory.size();
        }
    }

    public HintGCPolicy getUserRequestedGCPolicy() {
        return this.userRequestedGCPolicy;
    }

    static {
        Word.ensureInitialized();
        producedHeapChunkZapInt = WordFactory.unsigned((int)-1163018513);
        producedHeapChunkZapWord = producedHeapChunkZapInt.shiftLeft(32).or(producedHeapChunkZapInt);
        consumedHeapChunkZapInt = WordFactory.unsigned((int)-559038737);
        consumedHeapChunkZapWord = consumedHeapChunkZapInt.shiftLeft(32).or(consumedHeapChunkZapInt);
        bytesAllocatedSinceLastCollection = new AtomicUnsigned();
    }

    public static class ScepticallyCollect
    implements HintGCPolicy {
        @Override
        public void maybeCauseCollection(String message) {
            if (((UnsignedWord)bytesAllocatedSinceLastCollection.get()).aboveOrEqual(ScepticallyCollect.collectScepticallyThreshold())) {
                HeapImpl.getHeapImpl().getGCImpl().collect(message);
            }
        }

        public static UnsignedWord collectScepticallyThreshold() {
            return HeapPolicy.getMaximumYoungGenerationSize().subtract(WordFactory.unsigned((long)HeapPolicyOptions.UserRequestedGCThreshold.getValue()));
        }
    }

    public static class AlwaysCollectCompletely
    implements HintGCPolicy {
        @Override
        public void maybeCauseCollection(String message) {
            HeapImpl.getHeapImpl().getGC().collectCompletely(message);
        }
    }

    public static interface HintGCPolicy {
        public void maybeCauseCollection(String var1);
    }

    protected static abstract class CollectOnAllocationPolicy {
        CollectOnAllocationPolicy() {
        }

        public abstract void maybeCauseCollection();

        protected static class Sometimes
        extends CollectOnAllocationPolicy {
            public static Sometimes factory() {
                return new Sometimes();
            }

            @Override
            public void maybeCauseCollection() {
                HeapImpl heap = HeapImpl.getHeapImpl();
                if (((UnsignedWord)bytesAllocatedSinceLastCollection.get()).aboveOrEqual(HeapPolicy.getMaximumYoungGenerationSize())) {
                    heap.getGCImpl().collectWithoutAllocating("CollectOnAllocation.Sometimes");
                }
            }

            Sometimes() {
            }
        }

        protected static class Always
        extends CollectOnAllocationPolicy {
            public static Always factory() {
                return new Always();
            }

            @Override
            public void maybeCauseCollection() {
                HeapImpl.getHeapImpl().getGCImpl().collectWithoutAllocating("CollectOnAllocationPolicy.Always");
            }

            Always() {
            }
        }

        protected static class Never
        extends CollectOnAllocationPolicy {
            public static Never factory() {
                return new Never();
            }

            @Override
            public void maybeCauseCollection() {
            }

            Never() {
            }
        }
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static long getUnalignedObjectSize() {
            return HeapPolicy.getLargeArrayThreshold().rawValue();
        }
    }
}

