/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.amd64;

import com.oracle.svm.core.LibCHelper;
import com.oracle.svm.core.MemoryUtil;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;

public class AMD64CPUFeatureAccess {
    @Platforms(value={Platform.AMD64.class})
    public static EnumSet<AMD64.CPUFeature> determineHostCPUFeatures() {
        EnumSet<AMD64.CPUFeature> features = EnumSet.noneOf(AMD64.CPUFeature.class);
        LibCHelper.CPUFeatures cpuFeatures = (LibCHelper.CPUFeatures)StackValue.get(LibCHelper.CPUFeatures.class);
        MemoryUtil.fillToMemoryAtomic((Pointer)cpuFeatures, SizeOf.unsigned(LibCHelper.CPUFeatures.class), (byte)0);
        LibCHelper.determineCPUFeatures(cpuFeatures);
        if (cpuFeatures.fCX8()) {
            features.add(AMD64.CPUFeature.CX8);
        }
        if (cpuFeatures.fCMOV()) {
            features.add(AMD64.CPUFeature.CMOV);
        }
        if (cpuFeatures.fFXSR()) {
            features.add(AMD64.CPUFeature.FXSR);
        }
        if (cpuFeatures.fHT()) {
            features.add(AMD64.CPUFeature.HT);
        }
        if (cpuFeatures.fMMX()) {
            features.add(AMD64.CPUFeature.MMX);
        }
        if (cpuFeatures.fAMD3DNOWPREFETCH()) {
            features.add(AMD64.CPUFeature.AMD_3DNOW_PREFETCH);
        }
        if (cpuFeatures.fSSE()) {
            features.add(AMD64.CPUFeature.SSE);
        }
        if (cpuFeatures.fSSE2()) {
            features.add(AMD64.CPUFeature.SSE2);
        }
        if (cpuFeatures.fSSE3()) {
            features.add(AMD64.CPUFeature.SSE3);
        }
        if (cpuFeatures.fSSSE3()) {
            features.add(AMD64.CPUFeature.SSSE3);
        }
        if (cpuFeatures.fSSE4A()) {
            features.add(AMD64.CPUFeature.SSE4A);
        }
        if (cpuFeatures.fSSE41()) {
            features.add(AMD64.CPUFeature.SSE4_1);
        }
        if (cpuFeatures.fSSE42()) {
            features.add(AMD64.CPUFeature.SSE4_2);
        }
        if (cpuFeatures.fPOPCNT()) {
            features.add(AMD64.CPUFeature.POPCNT);
        }
        if (cpuFeatures.fLZCNT()) {
            features.add(AMD64.CPUFeature.LZCNT);
        }
        if (cpuFeatures.fTSC()) {
            features.add(AMD64.CPUFeature.TSC);
        }
        if (cpuFeatures.fTSCINV()) {
            features.add(AMD64.CPUFeature.TSCINV);
        }
        if (cpuFeatures.fAVX()) {
            features.add(AMD64.CPUFeature.AVX);
        }
        if (cpuFeatures.fAVX2()) {
            features.add(AMD64.CPUFeature.AVX2);
        }
        if (cpuFeatures.fAES()) {
            features.add(AMD64.CPUFeature.AES);
        }
        if (cpuFeatures.fERMS()) {
            features.add(AMD64.CPUFeature.ERMS);
        }
        if (cpuFeatures.fCLMUL()) {
            features.add(AMD64.CPUFeature.CLMUL);
        }
        if (cpuFeatures.fBMI1()) {
            features.add(AMD64.CPUFeature.BMI1);
        }
        if (cpuFeatures.fBMI2()) {
            features.add(AMD64.CPUFeature.BMI2);
        }
        if (cpuFeatures.fRTM()) {
            features.add(AMD64.CPUFeature.RTM);
        }
        if (cpuFeatures.fADX()) {
            features.add(AMD64.CPUFeature.ADX);
        }
        if (cpuFeatures.fAVX512F()) {
            features.add(AMD64.CPUFeature.AVX512F);
        }
        if (cpuFeatures.fAVX512DQ()) {
            features.add(AMD64.CPUFeature.AVX512DQ);
        }
        if (cpuFeatures.fAVX512PF()) {
            features.add(AMD64.CPUFeature.AVX512PF);
        }
        if (cpuFeatures.fAVX512ER()) {
            features.add(AMD64.CPUFeature.AVX512ER);
        }
        if (cpuFeatures.fAVX512CD()) {
            features.add(AMD64.CPUFeature.AVX512CD);
        }
        if (cpuFeatures.fAVX512BW()) {
            features.add(AMD64.CPUFeature.AVX512BW);
        }
        return features;
    }

    public static void verifyHostSupportsArchitecture(Architecture imageArchitecture) {
        AMD64 architecture = (AMD64)imageArchitecture;
        EnumSet<AMD64.CPUFeature> features = AMD64CPUFeatureAccess.determineHostCPUFeatures();
        if (!features.containsAll(architecture.getFeatures())) {
            ArrayList<AMD64.CPUFeature> missingFeatures = new ArrayList<AMD64.CPUFeature>();
            for (AMD64.CPUFeature feature : architecture.getFeatures()) {
                if (features.contains(feature)) continue;
                missingFeatures.add(feature);
            }
            throw VMError.shouldNotReachHere("Current target does not support the following CPU features that are required by the image: " + missingFeatures);
        }
    }
}

