/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisType;
import org.graalvm.compiler.nodes.ValueNode;

public class InstanceOfTypeFlow
extends TypeFlow<ValueNode> {
    private final BytecodeLocation location;

    public InstanceOfTypeFlow(ValueNode node, BytecodeLocation instanceOfLocation, AnalysisType declaredType) {
        super(node, declaredType);
        this.location = instanceOfLocation;
    }

    public InstanceOfTypeFlow(InstanceOfTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.location = original.location;
    }

    @Override
    public TypeFlow<ValueNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return new InstanceOfTypeFlow(this, methodFlows);
    }

    public BytecodeLocation getLocation() {
        return this.location;
    }

    @Override
    public String toString() {
        return "InstanceOfTypeFlow<" + this.getState() + ">";
    }
}

