/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.io.IOException;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jdk.internal.module.Modules;
import jdk.vm.ci.services.Services;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ModuleSupport {
    private ModuleSupport() {
    }

    public static List<String> getJVMCIModuleResources() {
        List<String> list;
        block9: {
            Module jvmciModule = Services.class.getModule();
            Optional<ModuleReference> moduleReference = ModuleFinder.ofSystem().find(jvmciModule.getName());
            assert (moduleReference.isPresent()) : "Unable access ModuleReference of JVMCI module";
            ModuleReader moduleReader = moduleReference.get().open();
            try {
                list = moduleReader.list().collect(Collectors.toList());
                if (moduleReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (moduleReader != null) {
                        try {
                            moduleReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable get list of resources in JVMCI module", e);
                }
            }
            moduleReader.close();
        }
        return list;
    }

    static void openModule(Class<?> declaringClass, Class<?> accessingClass) {
        Module accessingModule;
        String packageName;
        Module declaringModule = declaringClass.getModule();
        if (!declaringModule.isOpen(packageName = declaringClass.getPackageName(), accessingModule = accessingClass.getModule())) {
            Modules.addOpens(declaringModule, packageName, accessingModule);
        }
    }
}

