/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.util.GuardedAnnotationAccess;

public class AnalysisMethod
implements WrappedJavaMethod,
GraphProvider {
    private final AnalysisUniverse universe;
    public final ResolvedJavaMethod wrapped;
    private final int id;
    private final ExceptionHandler[] exceptionHandlers;
    private final LocalVariableTable localVariableTable;
    private MethodTypeFlow typeFlow;
    private boolean isRootMethod;
    private boolean isIntrinsicMethod;
    private Object entryPointData;
    private boolean isInvoked;
    private boolean isImplementationInvoked;
    protected AnalysisMethod[] implementations;
    private ConcurrentMap<InvokeTypeFlow, Object> invokedBy;
    private ConcurrentMap<InvokeTypeFlow, Object> implementationInvokedBy;

    public AnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.id = universe.nextMethodId.getAndIncrement();
        if (((Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options())).booleanValue()) {
            this.startTrackInvocations();
        }
        ExceptionHandler[] original = wrapped.getExceptionHandlers();
        this.exceptionHandlers = new ExceptionHandler[original.length];
        for (int i = 0; i < original.length; ++i) {
            ExceptionHandler h = original[i];
            JavaType catchType = this.getCatchType(h);
            this.exceptionHandlers[i] = new ExceptionHandler(h.getStartBCI(), h.getEndBCI(), h.getHandlerBCI(), h.catchTypeCPI(), catchType);
        }
        LocalVariableTable newLocalVariableTable = null;
        if (wrapped.getLocalVariableTable() != null) {
            try {
                Local[] origLocals = wrapped.getLocalVariableTable().getLocals();
                Local[] newLocals = new Local[origLocals.length];
                ResolvedJavaType accessingClass = this.getDeclaringClass().getWrapped();
                for (int i = 0; i < newLocals.length; ++i) {
                    Local origLocal = origLocals[i];
                    ResolvedJavaType origLocalType = origLocal.getType() instanceof ResolvedJavaType ? (ResolvedJavaType)origLocal.getType() : origLocal.getType().resolve(accessingClass);
                    AnalysisType type = universe.lookup((JavaType)origLocalType);
                    newLocals[i] = new Local(origLocal.getName(), (JavaType)type, origLocal.getStartBCI(), origLocal.getEndBCI(), origLocal.getSlot());
                }
                newLocalVariableTable = new LocalVariableTable(newLocals);
            }
            catch (UnsupportedFeatureException | LinkageError | BytecodeParser.BytecodeParserError e) {
                newLocalVariableTable = null;
            }
        }
        this.localVariableTable = newLocalVariableTable;
        this.typeFlow = new MethodTypeFlow(universe.hostVM().options(), this);
        if (this.getName().startsWith("$SWITCH_TABLE$")) {
            assert (Modifier.isStatic(this.getModifiers()));
            assert (this.getSignature().getParameterCount(false) == 0);
            try {
                Method switchTableMethod = this.getDeclaringClass().getJavaClass().getDeclaredMethod(this.getName(), new Class[0]);
                switchTableMethod.setAccessible(true);
                switchTableMethod.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw GraalError.shouldNotReachHere((Throwable)ex);
            }
        }
    }

    private JavaType getCatchType(ExceptionHandler handler) {
        ResolvedJavaType resolvedCatchType;
        JavaType catchType = handler.getCatchType();
        if (catchType == null) {
            return null;
        }
        try {
            resolvedCatchType = catchType.resolve(this.wrapped.getDeclaringClass());
        }
        catch (NoClassDefFoundError e) {
            return catchType;
        }
        return this.universe.lookup((JavaType)resolvedCatchType);
    }

    public void cleanupAfterAnalysis() {
        this.typeFlow = null;
        this.invokedBy = null;
        this.implementationInvokedBy = null;
    }

    private void startTrackInvocations() {
        if (this.invokedBy == null) {
            this.invokedBy = new ConcurrentHashMap<InvokeTypeFlow, Object>();
        }
        if (this.implementationInvokedBy == null) {
            this.implementationInvokedBy = new ConcurrentHashMap<InvokeTypeFlow, Object>();
        }
    }

    public int getId() {
        return this.id;
    }

    public MethodTypeFlow getTypeFlow() {
        return this.typeFlow;
    }

    public void registerAsIntrinsicMethod() {
        this.isIntrinsicMethod = true;
    }

    public void registerAsEntryPoint(Object newEntryPointData) {
        assert (newEntryPointData != null);
        if (this.entryPointData != null && !this.entryPointData.equals(newEntryPointData)) {
            throw new UnsupportedFeatureException("Method is registered as entry point with conflicting entry point data: " + this.entryPointData + ", " + newEntryPointData);
        }
        this.entryPointData = newEntryPointData;
        this.startTrackInvocations();
    }

    public void registerAsInvoked(InvokeTypeFlow invoke) {
        this.isInvoked = true;
        if (this.invokedBy != null && invoke != null) {
            this.invokedBy.put(invoke, Boolean.TRUE);
        }
    }

    public void registerAsImplementationInvoked(InvokeTypeFlow invoke) {
        assert (!Modifier.isAbstract(this.getModifiers()));
        this.isImplementationInvoked = true;
        if (this.implementationInvokedBy != null && invoke != null) {
            this.implementationInvokedBy.put(invoke, Boolean.TRUE);
        }
        this.getDeclaringClass().registerAsInTypeCheck();
    }

    public List<AnalysisMethod> getJavaInvocations() {
        ArrayList<AnalysisMethod> result = new ArrayList<AnalysisMethod>();
        for (InvokeTypeFlow invoke : this.implementationInvokedBy.keySet()) {
            result.add((AnalysisMethod)((MethodCallTargetNode)invoke.getSource()).graph().method());
        }
        return result;
    }

    public boolean isEntryPoint() {
        return this.entryPointData != null;
    }

    public Object getEntryPointData() {
        return this.entryPointData;
    }

    public boolean isIntrinsicMethod() {
        return this.isIntrinsicMethod;
    }

    public void registerAsRootMethod() {
        this.isRootMethod = true;
        this.getDeclaringClass().registerAsInTypeCheck();
    }

    public boolean isRootMethod() {
        return this.isRootMethod;
    }

    public boolean isSimplyInvoked() {
        return this.isInvoked;
    }

    public boolean isSimplyImplementationInvoked() {
        return this.isImplementationInvoked;
    }

    public boolean isInvoked() {
        return this.isIntrinsicMethod || this.isEntryPoint() || this.isInvoked;
    }

    public boolean isImplementationInvoked() {
        return !Modifier.isAbstract(this.getModifiers()) && (this.isIntrinsicMethod || this.isEntryPoint() || this.isImplementationInvoked);
    }

    @Override
    public ResolvedJavaMethod getWrapped() {
        return this.wrapped;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public WrappedSignature getSignature() {
        return this.universe.lookup(this.wrapped.getSignature(), (WrappedJavaType)this.getDeclaringClass());
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (this.wrapped instanceof GraphProvider) {
            return ((GraphProvider)this.wrapped).buildGraph(debug, method, providers, purpose);
        }
        return null;
    }

    public byte[] getCode() {
        return this.wrapped.getCode();
    }

    public int getCodeSize() {
        return this.wrapped.getCodeSize();
    }

    public AnalysisType getDeclaringClass() {
        return this.universe.lookup((JavaType)this.wrapped.getDeclaringClass());
    }

    public int getMaxLocals() {
        return this.wrapped.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.wrapped.getMaxStackSize();
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.wrapped.getParameters();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isVarArgs() {
        throw JVMCIError.unimplemented();
    }

    public boolean isBridge() {
        return this.wrapped.isBridge();
    }

    public boolean isClassInitializer() {
        return this.wrapped.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.wrapped.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        return this.wrapped.canBeStaticallyBound();
    }

    public AnalysisMethod[] getImplementations() {
        assert (this.universe.analysisDataValid);
        if (this.implementations == null) {
            return new AnalysisMethod[0];
        }
        return this.implementations;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.wrapped.asStackTraceElement(bci);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return StaticAnalysisResults.NO_RESULTS;
    }

    public ConstantPool getConstantPool() {
        return this.universe.lookup(this.wrapped.getConstantPool(), (WrappedJavaType)this.getDeclaringClass());
    }

    public Annotation[] getAnnotations() {
        return GuardedAnnotationAccess.getAnnotations((AnnotatedElement)this.wrapped);
    }

    public Annotation[] getDeclaredAnnotations() {
        return GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)this.wrapped);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)this.wrapped, annotationClass);
    }

    public Annotation[][] getParameterAnnotations() {
        return this.wrapped.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.wrapped.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return true;
    }

    public boolean hasNeverInlineDirective() {
        return this.wrapped.hasNeverInlineDirective();
    }

    public boolean shouldBeInlined() {
        throw JVMCIError.unimplemented();
    }

    public LineNumberTable getLineNumberTable() {
        return this.wrapped.getLineNumberTable();
    }

    public String toString() {
        return "AnalysisMethod<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void reprofile() {
        throw JVMCIError.unimplemented();
    }

    public Constant getEncoding() {
        throw JVMCIError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return false;
    }

    public boolean isDefault() {
        return this.wrapped.isDefault();
    }

    public SpeculationLog getSpeculationLog() {
        throw JVMCIError.shouldNotReachHere();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

