/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;

public abstract class TypeFlow<T> {
    protected static final AtomicInteger nextId = new AtomicInteger();
    protected final int id = nextId.incrementAndGet();
    protected final T source;
    protected final AnalysisType declaredType;
    private volatile TypeState state;
    private final ConcurrentLightHashSet<TypeFlow<?>> uses;
    private final ConcurrentLightHashSet<TypeFlow<?>> inputs;
    private final ConcurrentLightHashSet<TypeFlow<?>> observers;
    private final ConcurrentLightHashSet<TypeFlow<?>> observees;
    private int slot;
    private final boolean isClone;
    protected final MethodFlowsGraph graphRef;
    protected final AnalysisContext context;
    protected boolean usedAsAParameter;
    protected boolean usedAsAReceiver;
    public volatile boolean inQueue;
    private static final AtomicReferenceFieldUpdater<TypeFlow, TypeState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, TypeState.class, "state");

    private TypeFlow(T source, AnalysisType declaredType, TypeState typeState, int slot, boolean isClone, MethodFlowsGraph graphRef) {
        this.source = source;
        this.declaredType = declaredType;
        this.slot = slot;
        this.isClone = isClone;
        this.graphRef = graphRef;
        this.context = graphRef != null ? graphRef.context() : null;
        this.state = typeState;
        this.uses = new ConcurrentLightHashSet();
        this.inputs = new ConcurrentLightHashSet();
        this.observers = new ConcurrentLightHashSet();
        this.observees = new ConcurrentLightHashSet();
        this.usedAsAParameter = false;
        this.usedAsAReceiver = false;
    }

    public TypeFlow() {
        this(null, null, TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(TypeState typeState) {
        this(null, null, typeState, -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType) {
        this(source, declaredType, TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType, TypeState state) {
        this(source, declaredType, state, -1, false, null);
    }

    public TypeFlow(TypeFlow<T> original, MethodFlowsGraph graphRef) {
        this(original.getSource(), original.getDeclaredType(), TypeState.forEmpty(), original.getSlot(), true, graphRef);
        this.usedAsAParameter = original.usedAsAParameter;
        this.usedAsAReceiver = original.usedAsAReceiver;
        PointsToStats.registerTypeFlowRetainReason(this, original);
    }

    public TypeFlow<T> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return this;
    }

    public void initClone(BigBang bb) {
    }

    public void setUsedAsAParameter(boolean usedAsAParameter) {
        this.usedAsAParameter = usedAsAParameter;
    }

    public boolean isUsedAsAParameter() {
        return this.usedAsAParameter;
    }

    public void setUsedAsAReceiver(boolean usedAsAReceiver) {
        this.usedAsAReceiver = usedAsAReceiver;
    }

    public boolean isUsedAsAReceiver() {
        return this.usedAsAReceiver;
    }

    public TypeFlow<?> receiver() {
        return null;
    }

    public int id() {
        return this.id;
    }

    public AnalysisContext context() {
        return this.context;
    }

    public MethodFlowsGraph graphRef() {
        return this.graphRef;
    }

    public AnalysisMethod method() {
        return this.graphRef != null ? this.graphRef.getMethod() : null;
    }

    public T getSource() {
        return this.source;
    }

    public boolean isClone() {
        return this.isClone;
    }

    public AnalysisType getDeclaredType() {
        return this.declaredType;
    }

    public TypeState getState() {
        return this.state;
    }

    public boolean isAllInstantiated() {
        return this instanceof AllInstantiatedTypeFlow;
    }

    public boolean isCloseToAllInstantiated(BigBang bb) {
        return this.getState().closeToAllInstantiated(bb);
    }

    public void setState(BigBang bb, TypeState state) {
        assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || this instanceof InstanceOfTypeFlow || state.verifyDeclaredType(this.declaredType)) : "declaredType: " + this.declaredType.toJavaName(true) + " state: " + state;
        this.state = state;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean addState(BigBang bb, TypeState add) {
        return this.addState(bb, add, true);
    }

    public boolean addState(BigBang bb, TypeState add, boolean postFlow) {
        TypeState after;
        TypeState before;
        PointsToStats.registerTypeFlowUpdate(bb, this, add);
        do {
            TypeState filteredAdd;
            if (!(after = TypeState.forUnion(bb, before = this.state, filteredAdd = this.filter(bb, add))).equals(before)) continue;
            return false;
        } while (!STATE_UPDATER.compareAndSet(this, before, after));
        PointsToStats.registerTypeFlowSuccessfulUpdate(bb, this, add);
        assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || this instanceof InstanceOfTypeFlow || after.verifyDeclaredType(this.declaredType)) : "declaredType: " + this.declaredType.toJavaName(true) + " after: " + after + " before: " + before + " this: " + this;
        if (postFlow) {
            bb.postFlow(this);
        }
        return true;
    }

    public boolean addOriginalUse(BigBang bb, TypeFlow<?> use) {
        return this.addUse(bb, use, false, false);
    }

    public boolean addUse(BigBang bb, TypeFlow<?> use) {
        return this.addUse(bb, use, true, false);
    }

    private boolean addUse(BigBang bb, TypeFlow<?> use, boolean propagateTypeState, boolean registerInput) {
        if (this.doAddUse(bb, use, registerInput)) {
            if (propagateTypeState) {
                use.addState(bb, this.getState());
            }
            return true;
        }
        return false;
    }

    protected boolean doAddUse(BigBang bb, TypeFlow<?> use, boolean registerInput) {
        if (use.equals(this)) {
            return false;
        }
        if (bb.trackTypeFlowInputs() || registerInput) {
            use.addInput(this);
        }
        return this.uses.addElement(use);
    }

    public Collection<TypeFlow<?>> getUses() {
        return this.uses.getElements();
    }

    public boolean removeUse(TypeFlow<?> use) {
        use.removeInput(this);
        return this.uses.removeElement(use);
    }

    public void clearUses() {
        this.uses.clear();
    }

    public boolean addOriginalObserver(BigBang bb, TypeFlow<?> observer) {
        return this.addObserver(bb, observer, false, false);
    }

    public void addObserver(BigBang bb, TypeFlow<?> observer) {
        this.addObserver(bb, observer, true, false);
    }

    private boolean addObserver(BigBang bb, TypeFlow<?> observer, boolean triggerUpdate, boolean registerObservees) {
        if (this.doAddObserver(bb, observer, registerObservees)) {
            if (triggerUpdate) {
                observer.onObservedUpdate(bb);
            }
            return true;
        }
        return false;
    }

    protected boolean doAddObserver(BigBang bb, TypeFlow<?> observer, boolean registerObservees) {
        if (observer.equals(this)) {
            return false;
        }
        if (bb.trackTypeFlowInputs() || registerObservees) {
            observer.addObservee(this);
        }
        return this.observers.addElement(observer);
    }

    public boolean removeObserver(TypeFlow<?> observer) {
        observer.removeObservee(this);
        return this.observers.removeElement(observer);
    }

    public Collection<TypeFlow<?>> getObservers() {
        return this.observers.getElements();
    }

    protected void notifyObservers(BigBang bb) {
        for (TypeFlow<?> observer : this.getObservers()) {
            observer.onObservedUpdate(bb);
        }
    }

    public void addObservee(TypeFlow<?> observee) {
        this.observees.addElement(observee);
    }

    public Collection<TypeFlow<?>> getObservees() {
        return this.observees.getElements();
    }

    public boolean removeObservee(TypeFlow<?> observee) {
        return this.observees.removeElement(observee);
    }

    public void addInput(TypeFlow<?> input) {
        this.inputs.addElement(input);
    }

    public Collection<TypeFlow<?>> getInputs() {
        return this.inputs.getElements();
    }

    public boolean removeInput(TypeFlow<?> input) {
        return this.inputs.removeElement(input);
    }

    public TypeState filter(BigBang bb, TypeState newState) {
        return newState;
    }

    public void update(BigBang bb) {
        TypeState curState = this.getState();
        for (TypeFlow<?> use : this.getUses()) {
            use.addState(bb, curState);
        }
        this.notifyObservers(bb);
    }

    public void onObservedUpdate(BigBang bb) {
    }

    public String toString() {
        return "TypeFlow<" + (this.source instanceof Node ? ((StructuredGraph)((Node)this.source).graph()).method().format("%h.%n@") : "") + this.source + ": " + this.getState() + ">";
    }

    public final boolean equals(Object other) {
        return other == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }
}

