/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.EndpointIpPolicy;
import com.ngrok.definitions.EndpointIpPolicyMutate;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class TcpEdgeIpRestrictionModule {
    private final NgrokApiClient apiClient;

    public TcpEdgeIpRestrictionModule(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public ReplaceCallBuilder replace(String id) {
        return new ReplaceCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public class ReplaceCallBuilder {
        private final String id;
        private Optional<EndpointIpPolicyMutate> module = Optional.empty();

        private ReplaceCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public ReplaceCallBuilder module(EndpointIpPolicyMutate module) {
            this.module = Optional.of(Objects.requireNonNull(module, "module is required"));
            return this;
        }

        public ReplaceCallBuilder module(Optional<EndpointIpPolicyMutate> module) {
            this.module = Objects.requireNonNull(module, "module is required");
            return this;
        }

        public CompletionStage<EndpointIpPolicy> call() {
            return TcpEdgeIpRestrictionModule.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PUT, "/edges/tcp/" + this.id + "/ip_restriction", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("module", this.module.map(Function.identity()))), Optional.of(EndpointIpPolicy.class));
        }

        public EndpointIpPolicy blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<EndpointIpPolicy> call() {
            return TcpEdgeIpRestrictionModule.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/edges/tcp/" + this.id + "/ip_restriction", Stream.empty(), Stream.empty(), Optional.of(EndpointIpPolicy.class));
        }

        public EndpointIpPolicy blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return TcpEdgeIpRestrictionModule.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/edges/tcp/" + this.id + "/ip_restriction", Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

