/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.Page;
import com.ngrok.definitions.SshUserCertificate;
import com.ngrok.definitions.SshUserCertificateList;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class SshUserCertificates {
    private final NgrokApiClient apiClient;

    public SshUserCertificates(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create(String sshCertificateAuthorityId, String publicKey) {
        return new CreateCallBuilder(sshCertificateAuthorityId, publicKey);
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private final String sshCertificateAuthorityId;
        private final String publicKey;
        private List<String> principals = Collections.emptyList();
        private Map<String, String> criticalOptions = Collections.emptyMap();
        private Map<String, String> extensions = Collections.emptyMap();
        private Optional<OffsetDateTime> validAfter = Optional.empty();
        private Optional<OffsetDateTime> validUntil = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();

        private CreateCallBuilder(String sshCertificateAuthorityId, String publicKey) {
            this.sshCertificateAuthorityId = Objects.requireNonNull(sshCertificateAuthorityId, "sshCertificateAuthorityId is required");
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey is required");
        }

        public CreateCallBuilder principals(List<String> principals) {
            this.principals = Objects.requireNonNull(principals, "principals is required");
            return this;
        }

        public CreateCallBuilder principals(Optional<List<String>> principals) {
            this.principals = Objects.requireNonNull(principals, "principals is required").orElse(Collections.emptyList());
            return this;
        }

        public CreateCallBuilder criticalOptions(Map<String, String> criticalOptions) {
            this.criticalOptions = Objects.requireNonNull(criticalOptions, "criticalOptions is required");
            return this;
        }

        public CreateCallBuilder criticalOptions(Optional<Map<String, String>> criticalOptions) {
            this.criticalOptions = Objects.requireNonNull(criticalOptions, "criticalOptions is required").orElse(Collections.emptyMap());
            return this;
        }

        public CreateCallBuilder extensions(Map<String, String> extensions) {
            this.extensions = Objects.requireNonNull(extensions, "extensions is required");
            return this;
        }

        public CreateCallBuilder extensions(Optional<Map<String, String>> extensions) {
            this.extensions = Objects.requireNonNull(extensions, "extensions is required").orElse(Collections.emptyMap());
            return this;
        }

        public CreateCallBuilder validAfter(OffsetDateTime validAfter) {
            this.validAfter = Optional.of(Objects.requireNonNull(validAfter, "validAfter is required"));
            return this;
        }

        public CreateCallBuilder validAfter(Optional<OffsetDateTime> validAfter) {
            this.validAfter = Objects.requireNonNull(validAfter, "validAfter is required");
            return this;
        }

        public CreateCallBuilder validUntil(OffsetDateTime validUntil) {
            this.validUntil = Optional.of(Objects.requireNonNull(validUntil, "validUntil is required"));
            return this;
        }

        public CreateCallBuilder validUntil(Optional<OffsetDateTime> validUntil) {
            this.validUntil = Objects.requireNonNull(validUntil, "validUntil is required");
            return this;
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CompletionStage<SshUserCertificate> call() {
            return SshUserCertificates.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/ssh_user_certificates", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry<String, Optional<String>>("ssh_certificate_authority_id", Optional.of(this.sshCertificateAuthorityId)), new AbstractMap.SimpleEntry<String, Optional<String>>("public_key", Optional.of(this.publicKey)), new AbstractMap.SimpleEntry("principals", Optional.of(this.principals).filter(principals -> !principals.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("critical_options", Optional.of(this.criticalOptions).filter(criticalOptions -> !criticalOptions.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("extensions", Optional.of(this.extensions).filter(extensions -> !extensions.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("valid_after", this.validAfter.map(Function.identity())), new AbstractMap.SimpleEntry("valid_until", this.validUntil.map(Function.identity())), new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity()))), Optional.of(SshUserCertificate.class));
        }

        public SshUserCertificate blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return SshUserCertificates.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/ssh_user_certificates/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<SshUserCertificate> call() {
            return SshUserCertificates.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ssh_user_certificates/" + this.id, Stream.empty(), Stream.empty(), Optional.of(SshUserCertificate.class));
        }

        public SshUserCertificate blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<SshUserCertificateList>> call() {
            return SshUserCertificates.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ssh_user_certificates", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(SshUserCertificateList.class)).thenApply(list -> new Page<SshUserCertificateList>(SshUserCertificates.this.apiClient, (SshUserCertificateList)list));
        }

        public Page<SshUserCertificateList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CompletionStage<SshUserCertificate> call() {
            return SshUserCertificates.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/ssh_user_certificates/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity()))), Optional.of(SshUserCertificate.class));
        }

        public SshUserCertificate blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

