/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.Page;
import com.ngrok.definitions.SshCredential;
import com.ngrok.definitions.SshCredentialList;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class SshCredentials {
    private final NgrokApiClient apiClient;

    public SshCredentials(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create(String publicKey) {
        return new CreateCallBuilder(publicKey);
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private List<String> acl = Collections.emptyList();
        private final String publicKey;

        private CreateCallBuilder(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey is required");
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CreateCallBuilder acl(List<String> acl) {
            this.acl = Objects.requireNonNull(acl, "acl is required");
            return this;
        }

        public CreateCallBuilder acl(Optional<List<String>> acl) {
            this.acl = Objects.requireNonNull(acl, "acl is required").orElse(Collections.emptyList());
            return this;
        }

        public CompletionStage<SshCredential> call() {
            return SshCredentials.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/ssh_credentials", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("acl", Optional.of(this.acl).filter(acl -> !acl.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry<String, Optional<String>>("public_key", Optional.of(this.publicKey))), Optional.of(SshCredential.class));
        }

        public SshCredential blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return SshCredentials.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/ssh_credentials/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<SshCredential> call() {
            return SshCredentials.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ssh_credentials/" + this.id, Stream.empty(), Stream.empty(), Optional.of(SshCredential.class));
        }

        public SshCredential blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<SshCredentialList>> call() {
            return SshCredentials.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ssh_credentials", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(SshCredentialList.class)).thenApply(list -> new Page<SshCredentialList>(SshCredentials.this.apiClient, (SshCredentialList)list));
        }

        public Page<SshCredentialList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private List<String> acl = Collections.emptyList();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder acl(List<String> acl) {
            this.acl = Objects.requireNonNull(acl, "acl is required");
            return this;
        }

        public UpdateCallBuilder acl(Optional<List<String>> acl) {
            this.acl = Objects.requireNonNull(acl, "acl is required").orElse(Collections.emptyList());
            return this;
        }

        public CompletionStage<SshCredential> call() {
            return SshCredentials.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/ssh_credentials/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("acl", Optional.of(this.acl).filter(acl -> !acl.isEmpty()).map(Function.identity()))), Optional.of(SshCredential.class));
        }

        public SshCredential blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

