/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.Page;
import com.ngrok.definitions.ReservedDomain;
import com.ngrok.definitions.ReservedDomainCertPolicy;
import com.ngrok.definitions.ReservedDomainList;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class ReservedDomains {
    private final NgrokApiClient apiClient;

    public ReservedDomains(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create(String name) {
        return new CreateCallBuilder(name);
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public DeleteCertificateManagementPolicyCallBuilder deleteCertificateManagementPolicy(String id) {
        return new DeleteCertificateManagementPolicyCallBuilder(id);
    }

    public DeleteCertificateCallBuilder deleteCertificate(String id) {
        return new DeleteCertificateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private final String name;
        private Optional<String> region = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<String> certificateId = Optional.empty();
        private Optional<ReservedDomainCertPolicy> certificateManagementPolicy = Optional.empty();

        private CreateCallBuilder(String name) {
            this.name = Objects.requireNonNull(name, "name is required");
        }

        public CreateCallBuilder region(String region) {
            this.region = Optional.of(Objects.requireNonNull(region, "region is required"));
            return this;
        }

        public CreateCallBuilder region(Optional<String> region) {
            this.region = Objects.requireNonNull(region, "region is required");
            return this;
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CreateCallBuilder certificateId(String certificateId) {
            this.certificateId = Optional.of(Objects.requireNonNull(certificateId, "certificateId is required"));
            return this;
        }

        public CreateCallBuilder certificateId(Optional<String> certificateId) {
            this.certificateId = Objects.requireNonNull(certificateId, "certificateId is required");
            return this;
        }

        public CreateCallBuilder certificateManagementPolicy(ReservedDomainCertPolicy certificateManagementPolicy) {
            this.certificateManagementPolicy = Optional.of(Objects.requireNonNull(certificateManagementPolicy, "certificateManagementPolicy is required"));
            return this;
        }

        public CreateCallBuilder certificateManagementPolicy(Optional<ReservedDomainCertPolicy> certificateManagementPolicy) {
            this.certificateManagementPolicy = Objects.requireNonNull(certificateManagementPolicy, "certificateManagementPolicy is required");
            return this;
        }

        public CompletionStage<ReservedDomain> call() {
            return ReservedDomains.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/reserved_domains", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry<String, Optional<String>>("name", Optional.of(this.name)), new AbstractMap.SimpleEntry("region", this.region.map(Function.identity())), new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("certificate_id", this.certificateId.map(Function.identity())), new AbstractMap.SimpleEntry("certificate_management_policy", this.certificateManagementPolicy.map(Function.identity()))), Optional.of(ReservedDomain.class));
        }

        public ReservedDomain blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return ReservedDomains.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/reserved_domains/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<ReservedDomain> call() {
            return ReservedDomains.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/reserved_domains/" + this.id, Stream.empty(), Stream.empty(), Optional.of(ReservedDomain.class));
        }

        public ReservedDomain blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<ReservedDomainList>> call() {
            return ReservedDomains.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/reserved_domains", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(ReservedDomainList.class)).thenApply(list -> new Page<ReservedDomainList>(ReservedDomains.this.apiClient, (ReservedDomainList)list));
        }

        public Page<ReservedDomainList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<String> certificateId = Optional.empty();
        private Optional<ReservedDomainCertPolicy> certificateManagementPolicy = Optional.empty();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder certificateId(String certificateId) {
            this.certificateId = Optional.of(Objects.requireNonNull(certificateId, "certificateId is required"));
            return this;
        }

        public UpdateCallBuilder certificateId(Optional<String> certificateId) {
            this.certificateId = Objects.requireNonNull(certificateId, "certificateId is required");
            return this;
        }

        public UpdateCallBuilder certificateManagementPolicy(ReservedDomainCertPolicy certificateManagementPolicy) {
            this.certificateManagementPolicy = Optional.of(Objects.requireNonNull(certificateManagementPolicy, "certificateManagementPolicy is required"));
            return this;
        }

        public UpdateCallBuilder certificateManagementPolicy(Optional<ReservedDomainCertPolicy> certificateManagementPolicy) {
            this.certificateManagementPolicy = Objects.requireNonNull(certificateManagementPolicy, "certificateManagementPolicy is required");
            return this;
        }

        public CompletionStage<ReservedDomain> call() {
            return ReservedDomains.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/reserved_domains/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("certificate_id", this.certificateId.map(Function.identity())), new AbstractMap.SimpleEntry("certificate_management_policy", this.certificateManagementPolicy.map(Function.identity()))), Optional.of(ReservedDomain.class));
        }

        public ReservedDomain blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCertificateManagementPolicyCallBuilder {
        private final String id;

        private DeleteCertificateManagementPolicyCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return ReservedDomains.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/reserved_domains/" + this.id + "/certificate_management_policy", Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCertificateCallBuilder {
        private final String id;

        private DeleteCertificateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return ReservedDomains.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/reserved_domains/" + this.id + "/certificate", Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

