/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.IpRestriction;
import com.ngrok.definitions.IpRestrictionList;
import com.ngrok.definitions.Page;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class IpRestrictions {
    private final NgrokApiClient apiClient;

    public IpRestrictions(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create(String type, List<String> ipPolicyIds) {
        return new CreateCallBuilder(type, ipPolicyIds);
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<Boolean> enforced = Optional.empty();
        private final String type;
        private List<String> ipPolicyIds = Collections.emptyList();

        private CreateCallBuilder(String type, List<String> ipPolicyIds) {
            this.type = Objects.requireNonNull(type, "type is required");
            this.ipPolicyIds = Objects.requireNonNull(ipPolicyIds, "ipPolicyIds is required");
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CreateCallBuilder enforced(boolean enforced) {
            this.enforced = Optional.of(Objects.requireNonNull(Boolean.valueOf(enforced), "enforced is required"));
            return this;
        }

        public CreateCallBuilder enforced(Optional<Boolean> enforced) {
            this.enforced = Objects.requireNonNull(enforced, "enforced is required");
            return this;
        }

        public CompletionStage<IpRestriction> call() {
            return IpRestrictions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/ip_restrictions", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("enforced", this.enforced.map(Function.identity())), new AbstractMap.SimpleEntry<String, Optional<String>>("type", Optional.of(this.type)), new AbstractMap.SimpleEntry("ip_policy_ids", Optional.of(this.ipPolicyIds).filter(ipPolicyIds -> !ipPolicyIds.isEmpty()).map(Function.identity()))), Optional.of(IpRestriction.class));
        }

        public IpRestriction blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return IpRestrictions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/ip_restrictions/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<IpRestriction> call() {
            return IpRestrictions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ip_restrictions/" + this.id, Stream.empty(), Stream.empty(), Optional.of(IpRestriction.class));
        }

        public IpRestriction blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<IpRestrictionList>> call() {
            return IpRestrictions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ip_restrictions", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(IpRestrictionList.class)).thenApply(list -> new Page<IpRestrictionList>(IpRestrictions.this.apiClient, (IpRestrictionList)list));
        }

        public Page<IpRestrictionList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<Boolean> enforced = Optional.empty();
        private List<String> ipPolicyIds = Collections.emptyList();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder enforced(boolean enforced) {
            this.enforced = Optional.of(Objects.requireNonNull(Boolean.valueOf(enforced), "enforced is required"));
            return this;
        }

        public UpdateCallBuilder enforced(Optional<Boolean> enforced) {
            this.enforced = Objects.requireNonNull(enforced, "enforced is required");
            return this;
        }

        public UpdateCallBuilder ipPolicyIds(List<String> ipPolicyIds) {
            this.ipPolicyIds = Objects.requireNonNull(ipPolicyIds, "ipPolicyIds is required");
            return this;
        }

        public UpdateCallBuilder ipPolicyIds(Optional<List<String>> ipPolicyIds) {
            this.ipPolicyIds = Objects.requireNonNull(ipPolicyIds, "ipPolicyIds is required").orElse(Collections.emptyList());
            return this;
        }

        public CompletionStage<IpRestriction> call() {
            return IpRestrictions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/ip_restrictions/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("enforced", this.enforced.map(Function.identity())), new AbstractMap.SimpleEntry("ip_policy_ids", Optional.of(this.ipPolicyIds).filter(ipPolicyIds -> !ipPolicyIds.isEmpty()).map(Function.identity()))), Optional.of(IpRestriction.class));
        }

        public IpRestriction blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

