/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.IpPolicyRule;
import com.ngrok.definitions.IpPolicyRuleList;
import com.ngrok.definitions.Page;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class IpPolicyRules {
    private final NgrokApiClient apiClient;

    public IpPolicyRules(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create(String cidr, String ipPolicyId, String action) {
        return new CreateCallBuilder(cidr, ipPolicyId, action);
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private final String cidr;
        private final String ipPolicyId;
        private final String action;

        private CreateCallBuilder(String cidr, String ipPolicyId, String action) {
            this.cidr = Objects.requireNonNull(cidr, "cidr is required");
            this.ipPolicyId = Objects.requireNonNull(ipPolicyId, "ipPolicyId is required");
            this.action = Objects.requireNonNull(action, "action is required");
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CompletionStage<IpPolicyRule> call() {
            return IpPolicyRules.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/ip_policy_rules", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry<String, Optional<String>>("cidr", Optional.of(this.cidr)), new AbstractMap.SimpleEntry<String, Optional<String>>("ip_policy_id", Optional.of(this.ipPolicyId)), new AbstractMap.SimpleEntry<String, Optional<String>>("action", Optional.of(this.action))), Optional.of(IpPolicyRule.class));
        }

        public IpPolicyRule blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return IpPolicyRules.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/ip_policy_rules/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<IpPolicyRule> call() {
            return IpPolicyRules.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ip_policy_rules/" + this.id, Stream.empty(), Stream.empty(), Optional.of(IpPolicyRule.class));
        }

        public IpPolicyRule blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<IpPolicyRuleList>> call() {
            return IpPolicyRules.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ip_policy_rules", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(IpPolicyRuleList.class)).thenApply(list -> new Page<IpPolicyRuleList>(IpPolicyRules.this.apiClient, (IpPolicyRuleList)list));
        }

        public Page<IpPolicyRuleList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<String> cidr = Optional.empty();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder cidr(String cidr) {
            this.cidr = Optional.of(Objects.requireNonNull(cidr, "cidr is required"));
            return this;
        }

        public UpdateCallBuilder cidr(Optional<String> cidr) {
            this.cidr = Objects.requireNonNull(cidr, "cidr is required");
            return this;
        }

        public CompletionStage<IpPolicyRule> call() {
            return IpPolicyRules.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/ip_policy_rules/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("cidr", this.cidr.map(Function.identity()))), Optional.of(IpPolicyRule.class));
        }

        public IpPolicyRule blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

