/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.IpPolicy;
import com.ngrok.definitions.IpPolicyList;
import com.ngrok.definitions.Page;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class IpPolicies {
    private final NgrokApiClient apiClient;

    public IpPolicies(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create() {
        return new CreateCallBuilder();
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();

        private CreateCallBuilder() {
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CompletionStage<IpPolicy> call() {
            return IpPolicies.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/ip_policies", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity()))), Optional.of(IpPolicy.class));
        }

        public IpPolicy blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return IpPolicies.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/ip_policies/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<IpPolicy> call() {
            return IpPolicies.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ip_policies/" + this.id, Stream.empty(), Stream.empty(), Optional.of(IpPolicy.class));
        }

        public IpPolicy blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<IpPolicyList>> call() {
            return IpPolicies.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/ip_policies", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(IpPolicyList.class)).thenApply(list -> new Page<IpPolicyList>(IpPolicies.this.apiClient, (IpPolicyList)list));
        }

        public Page<IpPolicyList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CompletionStage<IpPolicy> call() {
            return IpPolicies.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/ip_policies/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity()))), Optional.of(IpPolicy.class));
        }

        public IpPolicy blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

