/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.HttpResponseBackend;
import com.ngrok.definitions.HttpResponseBackendList;
import com.ngrok.definitions.Page;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class HttpResponseBackends {
    private final NgrokApiClient apiClient;

    public HttpResponseBackends(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create() {
        return new CreateCallBuilder();
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Map<String, String> headers = Collections.emptyMap();
        private Optional<Integer> statusCode = Optional.empty();

        private CreateCallBuilder() {
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CreateCallBuilder body(String body) {
            this.body = Optional.of(Objects.requireNonNull(body, "body is required"));
            return this;
        }

        public CreateCallBuilder body(Optional<String> body) {
            this.body = Objects.requireNonNull(body, "body is required");
            return this;
        }

        public CreateCallBuilder headers(Map<String, String> headers) {
            this.headers = Objects.requireNonNull(headers, "headers is required");
            return this;
        }

        public CreateCallBuilder headers(Optional<Map<String, String>> headers) {
            this.headers = Objects.requireNonNull(headers, "headers is required").orElse(Collections.emptyMap());
            return this;
        }

        public CreateCallBuilder statusCode(int statusCode) {
            this.statusCode = Optional.of(Objects.requireNonNull(Integer.valueOf(statusCode), "statusCode is required"));
            return this;
        }

        public CreateCallBuilder statusCode(Optional<Integer> statusCode) {
            this.statusCode = Objects.requireNonNull(statusCode, "statusCode is required");
            return this;
        }

        public CompletionStage<HttpResponseBackend> call() {
            return HttpResponseBackends.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/backends/http_response", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("body", this.body.map(Function.identity())), new AbstractMap.SimpleEntry("headers", Optional.of(this.headers).filter(headers -> !headers.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("status_code", this.statusCode.map(Function.identity()))), Optional.of(HttpResponseBackend.class));
        }

        public HttpResponseBackend blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return HttpResponseBackends.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/backends/http_response/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<HttpResponseBackend> call() {
            return HttpResponseBackends.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/backends/http_response/" + this.id, Stream.empty(), Stream.empty(), Optional.of(HttpResponseBackend.class));
        }

        public HttpResponseBackend blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<HttpResponseBackendList>> call() {
            return HttpResponseBackends.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/backends/http_response", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(HttpResponseBackendList.class)).thenApply(list -> new Page<HttpResponseBackendList>(HttpResponseBackends.this.apiClient, (HttpResponseBackendList)list));
        }

        public Page<HttpResponseBackendList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Map<String, String> headers = Collections.emptyMap();
        private Optional<Integer> statusCode = Optional.empty();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder body(String body) {
            this.body = Optional.of(Objects.requireNonNull(body, "body is required"));
            return this;
        }

        public UpdateCallBuilder body(Optional<String> body) {
            this.body = Objects.requireNonNull(body, "body is required");
            return this;
        }

        public UpdateCallBuilder headers(Map<String, String> headers) {
            this.headers = Objects.requireNonNull(headers, "headers is required");
            return this;
        }

        public UpdateCallBuilder headers(Optional<Map<String, String>> headers) {
            this.headers = Objects.requireNonNull(headers, "headers is required").orElse(Collections.emptyMap());
            return this;
        }

        public UpdateCallBuilder statusCode(int statusCode) {
            this.statusCode = Optional.of(Objects.requireNonNull(Integer.valueOf(statusCode), "statusCode is required"));
            return this;
        }

        public UpdateCallBuilder statusCode(Optional<Integer> statusCode) {
            this.statusCode = Objects.requireNonNull(statusCode, "statusCode is required");
            return this;
        }

        public CompletionStage<HttpResponseBackend> call() {
            return HttpResponseBackends.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/backends/http_response/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("body", this.body.map(Function.identity())), new AbstractMap.SimpleEntry("headers", Optional.of(this.headers).filter(headers -> !headers.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("status_code", this.statusCode.map(Function.identity()))), Optional.of(HttpResponseBackend.class));
        }

        public HttpResponseBackend blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

