/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.EventSourceReplace;
import com.ngrok.definitions.EventSubscription;
import com.ngrok.definitions.EventSubscriptionList;
import com.ngrok.definitions.Page;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class EventSubscriptions {
    private final NgrokApiClient apiClient;

    public EventSubscriptions(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create() {
        return new CreateCallBuilder();
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private Optional<String> metadata = Optional.empty();
        private Optional<String> description = Optional.empty();
        private List<EventSourceReplace> sources = Collections.emptyList();
        private List<String> destinationIds = Collections.emptyList();

        private CreateCallBuilder() {
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder sources(List<EventSourceReplace> sources) {
            this.sources = Objects.requireNonNull(sources, "sources is required");
            return this;
        }

        public CreateCallBuilder sources(Optional<List<EventSourceReplace>> sources) {
            this.sources = Objects.requireNonNull(sources, "sources is required").orElse(Collections.emptyList());
            return this;
        }

        public CreateCallBuilder destinationIds(List<String> destinationIds) {
            this.destinationIds = Objects.requireNonNull(destinationIds, "destinationIds is required");
            return this;
        }

        public CreateCallBuilder destinationIds(Optional<List<String>> destinationIds) {
            this.destinationIds = Objects.requireNonNull(destinationIds, "destinationIds is required").orElse(Collections.emptyList());
            return this;
        }

        public CompletionStage<EventSubscription> call() {
            return EventSubscriptions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/event_subscriptions", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("sources", Optional.of(this.sources).filter(sources -> !sources.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("destination_ids", Optional.of(this.destinationIds).filter(destinationIds -> !destinationIds.isEmpty()).map(Function.identity()))), Optional.of(EventSubscription.class));
        }

        public EventSubscription blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return EventSubscriptions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/event_subscriptions/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<EventSubscription> call() {
            return EventSubscriptions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/event_subscriptions/" + this.id, Stream.empty(), Stream.empty(), Optional.of(EventSubscription.class));
        }

        public EventSubscription blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<EventSubscriptionList>> call() {
            return EventSubscriptions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/event_subscriptions", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(EventSubscriptionList.class)).thenApply(list -> new Page<EventSubscriptionList>(EventSubscriptions.this.apiClient, (EventSubscriptionList)list));
        }

        public Page<EventSubscriptionList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> metadata = Optional.empty();
        private Optional<String> description = Optional.empty();
        private List<EventSourceReplace> sources = Collections.emptyList();
        private List<String> destinationIds = Collections.emptyList();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder sources(List<EventSourceReplace> sources) {
            this.sources = Objects.requireNonNull(sources, "sources is required");
            return this;
        }

        public UpdateCallBuilder sources(Optional<List<EventSourceReplace>> sources) {
            this.sources = Objects.requireNonNull(sources, "sources is required").orElse(Collections.emptyList());
            return this;
        }

        public UpdateCallBuilder destinationIds(List<String> destinationIds) {
            this.destinationIds = Objects.requireNonNull(destinationIds, "destinationIds is required");
            return this;
        }

        public UpdateCallBuilder destinationIds(Optional<List<String>> destinationIds) {
            this.destinationIds = Objects.requireNonNull(destinationIds, "destinationIds is required").orElse(Collections.emptyList());
            return this;
        }

        public CompletionStage<EventSubscription> call() {
            return EventSubscriptions.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/event_subscriptions/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("sources", Optional.of(this.sources).filter(sources -> !sources.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("destination_ids", Optional.of(this.destinationIds).filter(destinationIds -> !destinationIds.isEmpty()).map(Function.identity()))), Optional.of(EventSubscription.class));
        }

        public EventSubscription blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

