/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.EventSource;
import com.ngrok.definitions.EventSourceList;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class EventSources {
    private final NgrokApiClient apiClient;

    public EventSources(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create(String subscriptionId) {
        return new CreateCallBuilder(subscriptionId);
    }

    public DeleteCallBuilder delete(String subscriptionId, String type) {
        return new DeleteCallBuilder(subscriptionId, type);
    }

    public GetCallBuilder get(String subscriptionId, String type) {
        return new GetCallBuilder(subscriptionId, type);
    }

    public ListCallBuilder list(String subscriptionId) {
        return new ListCallBuilder(subscriptionId);
    }

    public UpdateCallBuilder update(String subscriptionId, String type) {
        return new UpdateCallBuilder(subscriptionId, type);
    }

    public class CreateCallBuilder {
        private final String subscriptionId;
        private Optional<String> type = Optional.empty();

        private CreateCallBuilder(String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId is required");
        }

        public CreateCallBuilder type(String type) {
            this.type = Optional.of(Objects.requireNonNull(type, "type is required"));
            return this;
        }

        public CreateCallBuilder type(Optional<String> type) {
            this.type = Objects.requireNonNull(type, "type is required");
            return this;
        }

        public CompletionStage<EventSource> call() {
            return EventSources.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/event_subscriptions/" + this.subscriptionId + "/sources", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("type", this.type.map(Function.identity()))), Optional.of(EventSource.class));
        }

        public EventSource blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String subscriptionId;
        private final String type;

        private DeleteCallBuilder(String subscriptionId, String type) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId is required");
            this.type = Objects.requireNonNull(type, "type is required");
        }

        public CompletionStage<Void> call() {
            return EventSources.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/event_subscriptions/" + this.subscriptionId + "/sources/" + this.type, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String subscriptionId;
        private final String type;

        private GetCallBuilder(String subscriptionId, String type) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId is required");
            this.type = Objects.requireNonNull(type, "type is required");
        }

        public CompletionStage<EventSource> call() {
            return EventSources.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/event_subscriptions/" + this.subscriptionId + "/sources/" + this.type, Stream.empty(), Stream.empty(), Optional.of(EventSource.class));
        }

        public EventSource blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private final String subscriptionId;

        private ListCallBuilder(String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId is required");
        }

        public CompletionStage<EventSourceList> call() {
            return EventSources.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/event_subscriptions/" + this.subscriptionId + "/sources", Stream.empty(), Stream.empty(), Optional.of(EventSourceList.class));
        }

        public EventSourceList blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String subscriptionId;
        private final String type;

        private UpdateCallBuilder(String subscriptionId, String type) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId is required");
            this.type = Objects.requireNonNull(type, "type is required");
        }

        public CompletionStage<EventSource> call() {
            return EventSources.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/event_subscriptions/" + this.subscriptionId + "/sources/" + this.type, Stream.empty(), Stream.empty(), Optional.of(EventSource.class));
        }

        public EventSource blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

