/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.EventDestination;
import com.ngrok.definitions.EventDestinationList;
import com.ngrok.definitions.EventTarget;
import com.ngrok.definitions.Page;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class EventDestinations {
    private final NgrokApiClient apiClient;

    public EventDestinations(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create() {
        return new CreateCallBuilder();
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public class CreateCallBuilder {
        private Optional<String> metadata = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> format = Optional.empty();
        private Optional<EventTarget> target = Optional.empty();

        private CreateCallBuilder() {
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder format(String format) {
            this.format = Optional.of(Objects.requireNonNull(format, "format is required"));
            return this;
        }

        public CreateCallBuilder format(Optional<String> format) {
            this.format = Objects.requireNonNull(format, "format is required");
            return this;
        }

        public CreateCallBuilder target(EventTarget target) {
            this.target = Optional.of(Objects.requireNonNull(target, "target is required"));
            return this;
        }

        public CreateCallBuilder target(Optional<EventTarget> target) {
            this.target = Objects.requireNonNull(target, "target is required");
            return this;
        }

        public CompletionStage<EventDestination> call() {
            return EventDestinations.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/event_destinations", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("format", this.format.map(Function.identity())), new AbstractMap.SimpleEntry("target", this.target.map(Function.identity()))), Optional.of(EventDestination.class));
        }

        public EventDestination blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return EventDestinations.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/event_destinations/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<EventDestination> call() {
            return EventDestinations.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/event_destinations/" + this.id, Stream.empty(), Stream.empty(), Optional.of(EventDestination.class));
        }

        public EventDestination blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<EventDestinationList>> call() {
            return EventDestinations.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/event_destinations", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(EventDestinationList.class)).thenApply(list -> new Page<EventDestinationList>(EventDestinations.this.apiClient, (EventDestinationList)list));
        }

        public Page<EventDestinationList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> metadata = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> format = Optional.empty();
        private Optional<EventTarget> target = Optional.empty();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder format(String format) {
            this.format = Optional.of(Objects.requireNonNull(format, "format is required"));
            return this;
        }

        public UpdateCallBuilder format(Optional<String> format) {
            this.format = Objects.requireNonNull(format, "format is required");
            return this;
        }

        public UpdateCallBuilder target(EventTarget target) {
            this.target = Optional.of(Objects.requireNonNull(target, "target is required"));
            return this;
        }

        public UpdateCallBuilder target(Optional<EventTarget> target) {
            this.target = Objects.requireNonNull(target, "target is required");
            return this;
        }

        public CompletionStage<EventDestination> call() {
            return EventDestinations.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/event_destinations/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("format", this.format.map(Function.identity())), new AbstractMap.SimpleEntry("target", this.target.map(Function.identity()))), Optional.of(EventDestination.class));
        }

        public EventDestination blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

