/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.Endpoint;
import com.ngrok.definitions.EndpointList;
import com.ngrok.definitions.Page;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class Endpoints {
    private final NgrokApiClient apiClient;

    public Endpoints(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<EndpointList>> call() {
            return Endpoints.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/endpoints", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(EndpointList.class)).thenApply(list -> new Page<EndpointList>(Endpoints.this.apiClient, (EndpointList)list));
        }

        public Page<EndpointList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Endpoint> call() {
            return Endpoints.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/endpoints/" + this.id, Stream.empty(), Stream.empty(), Optional.of(Endpoint.class));
        }

        public Endpoint blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

