/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.EndpointBackendMutate;
import com.ngrok.definitions.EndpointIpPolicyMutate;
import com.ngrok.definitions.EndpointMutualTlsMutate;
import com.ngrok.definitions.EndpointTlsTermination;
import com.ngrok.definitions.Page;
import com.ngrok.definitions.TlsEdge;
import com.ngrok.definitions.TlsEdgeList;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class EdgesTls {
    private final NgrokApiClient apiClient;

    public EdgesTls(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create() {
        return new CreateCallBuilder();
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public ListCallBuilder list() {
        return new ListCallBuilder();
    }

    public UpdateCallBuilder update(String id) {
        return new UpdateCallBuilder(id);
    }

    public DeleteCallBuilder delete(String id) {
        return new DeleteCallBuilder(id);
    }

    public class CreateCallBuilder {
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private List<String> hostports = Collections.emptyList();
        private Optional<EndpointBackendMutate> backend = Optional.empty();
        private Optional<EndpointIpPolicyMutate> ipRestriction = Optional.empty();
        private Optional<EndpointMutualTlsMutate> mutualTls = Optional.empty();
        private Optional<EndpointTlsTermination> tlsTermination = Optional.empty();

        private CreateCallBuilder() {
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CreateCallBuilder hostports(List<String> hostports) {
            this.hostports = Objects.requireNonNull(hostports, "hostports is required");
            return this;
        }

        public CreateCallBuilder hostports(Optional<List<String>> hostports) {
            this.hostports = Objects.requireNonNull(hostports, "hostports is required").orElse(Collections.emptyList());
            return this;
        }

        public CreateCallBuilder backend(EndpointBackendMutate backend) {
            this.backend = Optional.of(Objects.requireNonNull(backend, "backend is required"));
            return this;
        }

        public CreateCallBuilder backend(Optional<EndpointBackendMutate> backend) {
            this.backend = Objects.requireNonNull(backend, "backend is required");
            return this;
        }

        public CreateCallBuilder ipRestriction(EndpointIpPolicyMutate ipRestriction) {
            this.ipRestriction = Optional.of(Objects.requireNonNull(ipRestriction, "ipRestriction is required"));
            return this;
        }

        public CreateCallBuilder ipRestriction(Optional<EndpointIpPolicyMutate> ipRestriction) {
            this.ipRestriction = Objects.requireNonNull(ipRestriction, "ipRestriction is required");
            return this;
        }

        public CreateCallBuilder mutualTls(EndpointMutualTlsMutate mutualTls) {
            this.mutualTls = Optional.of(Objects.requireNonNull(mutualTls, "mutualTls is required"));
            return this;
        }

        public CreateCallBuilder mutualTls(Optional<EndpointMutualTlsMutate> mutualTls) {
            this.mutualTls = Objects.requireNonNull(mutualTls, "mutualTls is required");
            return this;
        }

        public CreateCallBuilder tlsTermination(EndpointTlsTermination tlsTermination) {
            this.tlsTermination = Optional.of(Objects.requireNonNull(tlsTermination, "tlsTermination is required"));
            return this;
        }

        public CreateCallBuilder tlsTermination(Optional<EndpointTlsTermination> tlsTermination) {
            this.tlsTermination = Objects.requireNonNull(tlsTermination, "tlsTermination is required");
            return this;
        }

        public CompletionStage<TlsEdge> call() {
            return EdgesTls.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/edges/tls", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("hostports", Optional.of(this.hostports).filter(hostports -> !hostports.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("backend", this.backend.map(Function.identity())), new AbstractMap.SimpleEntry("ip_restriction", this.ipRestriction.map(Function.identity())), new AbstractMap.SimpleEntry("mutual_tls", this.mutualTls.map(Function.identity())), new AbstractMap.SimpleEntry("tls_termination", this.tlsTermination.map(Function.identity()))), Optional.of(TlsEdge.class));
        }

        public TlsEdge blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<TlsEdge> call() {
            return EdgesTls.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/edges/tls/" + this.id, Stream.empty(), Stream.empty(), Optional.of(TlsEdge.class));
        }

        public TlsEdge blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class ListCallBuilder {
        private Optional<String> beforeId = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private ListCallBuilder() {
        }

        public ListCallBuilder beforeId(String beforeId) {
            this.beforeId = Optional.of(Objects.requireNonNull(beforeId, "beforeId is required"));
            return this;
        }

        public ListCallBuilder beforeId(Optional<String> beforeId) {
            this.beforeId = Objects.requireNonNull(beforeId, "beforeId is required");
            return this;
        }

        public ListCallBuilder limit(String limit) {
            this.limit = Optional.of(Objects.requireNonNull(limit, "limit is required"));
            return this;
        }

        public ListCallBuilder limit(Optional<String> limit) {
            this.limit = Objects.requireNonNull(limit, "limit is required");
            return this;
        }

        public CompletionStage<Page<TlsEdgeList>> call() {
            return EdgesTls.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/edges/tls", Stream.of(new AbstractMap.SimpleEntry("before_id", this.beforeId.map(Function.identity())), new AbstractMap.SimpleEntry("limit", this.limit.map(Function.identity()))), Stream.empty(), Optional.of(TlsEdgeList.class)).thenApply(list -> new Page<TlsEdgeList>(EdgesTls.this.apiClient, (TlsEdgeList)list));
        }

        public Page<TlsEdgeList> blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String id;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private List<String> hostports = Collections.emptyList();
        private Optional<EndpointBackendMutate> backend = Optional.empty();
        private Optional<EndpointIpPolicyMutate> ipRestriction = Optional.empty();
        private Optional<EndpointMutualTlsMutate> mutualTls = Optional.empty();
        private Optional<EndpointTlsTermination> tlsTermination = Optional.empty();

        private UpdateCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder hostports(List<String> hostports) {
            this.hostports = Objects.requireNonNull(hostports, "hostports is required");
            return this;
        }

        public UpdateCallBuilder hostports(Optional<List<String>> hostports) {
            this.hostports = Objects.requireNonNull(hostports, "hostports is required").orElse(Collections.emptyList());
            return this;
        }

        public UpdateCallBuilder backend(EndpointBackendMutate backend) {
            this.backend = Optional.of(Objects.requireNonNull(backend, "backend is required"));
            return this;
        }

        public UpdateCallBuilder backend(Optional<EndpointBackendMutate> backend) {
            this.backend = Objects.requireNonNull(backend, "backend is required");
            return this;
        }

        public UpdateCallBuilder ipRestriction(EndpointIpPolicyMutate ipRestriction) {
            this.ipRestriction = Optional.of(Objects.requireNonNull(ipRestriction, "ipRestriction is required"));
            return this;
        }

        public UpdateCallBuilder ipRestriction(Optional<EndpointIpPolicyMutate> ipRestriction) {
            this.ipRestriction = Objects.requireNonNull(ipRestriction, "ipRestriction is required");
            return this;
        }

        public UpdateCallBuilder mutualTls(EndpointMutualTlsMutate mutualTls) {
            this.mutualTls = Optional.of(Objects.requireNonNull(mutualTls, "mutualTls is required"));
            return this;
        }

        public UpdateCallBuilder mutualTls(Optional<EndpointMutualTlsMutate> mutualTls) {
            this.mutualTls = Objects.requireNonNull(mutualTls, "mutualTls is required");
            return this;
        }

        public UpdateCallBuilder tlsTermination(EndpointTlsTermination tlsTermination) {
            this.tlsTermination = Optional.of(Objects.requireNonNull(tlsTermination, "tlsTermination is required"));
            return this;
        }

        public UpdateCallBuilder tlsTermination(Optional<EndpointTlsTermination> tlsTermination) {
            this.tlsTermination = Objects.requireNonNull(tlsTermination, "tlsTermination is required");
            return this;
        }

        public CompletionStage<TlsEdge> call() {
            return EdgesTls.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/edges/tls/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("hostports", Optional.of(this.hostports).filter(hostports -> !hostports.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("backend", this.backend.map(Function.identity())), new AbstractMap.SimpleEntry("ip_restriction", this.ipRestriction.map(Function.identity())), new AbstractMap.SimpleEntry("mutual_tls", this.mutualTls.map(Function.identity())), new AbstractMap.SimpleEntry("tls_termination", this.tlsTermination.map(Function.identity()))), Optional.of(TlsEdge.class));
        }

        public TlsEdge blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String id;

        private DeleteCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return EdgesTls.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/edges/tls/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

