/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.EndpointBackendMutate;
import com.ngrok.definitions.EndpointCircuitBreaker;
import com.ngrok.definitions.EndpointCompression;
import com.ngrok.definitions.EndpointIpPolicyMutate;
import com.ngrok.definitions.EndpointOAuth;
import com.ngrok.definitions.EndpointOidc;
import com.ngrok.definitions.EndpointRequestHeaders;
import com.ngrok.definitions.EndpointResponseHeaders;
import com.ngrok.definitions.EndpointSamlMutate;
import com.ngrok.definitions.EndpointWebhookValidation;
import com.ngrok.definitions.EndpointWebsocketTcpConverter;
import com.ngrok.definitions.HttpsEdgeRoute;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class EdgesHttpsRoutes {
    private final NgrokApiClient apiClient;

    public EdgesHttpsRoutes(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create(String edgeId, String matchType, String match) {
        return new CreateCallBuilder(edgeId, matchType, match);
    }

    public GetCallBuilder get(String edgeId, String id) {
        return new GetCallBuilder(edgeId, id);
    }

    public UpdateCallBuilder update(String edgeId, String id) {
        return new UpdateCallBuilder(edgeId, id);
    }

    public DeleteCallBuilder delete(String edgeId, String id) {
        return new DeleteCallBuilder(edgeId, id);
    }

    public class CreateCallBuilder {
        private final String edgeId;
        private final String matchType;
        private final String match;
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<EndpointBackendMutate> backend = Optional.empty();
        private Optional<EndpointIpPolicyMutate> ipRestriction = Optional.empty();
        private Optional<EndpointCircuitBreaker> circuitBreaker = Optional.empty();
        private Optional<EndpointCompression> compression = Optional.empty();
        private Optional<EndpointRequestHeaders> requestHeaders = Optional.empty();
        private Optional<EndpointResponseHeaders> responseHeaders = Optional.empty();
        private Optional<EndpointWebhookValidation> webhookVerification = Optional.empty();
        private Optional<EndpointOAuth> oauth = Optional.empty();
        private Optional<EndpointSamlMutate> saml = Optional.empty();
        private Optional<EndpointOidc> oidc = Optional.empty();
        private Optional<EndpointWebsocketTcpConverter> websocketTcpConverter = Optional.empty();

        private CreateCallBuilder(String edgeId, String matchType, String match) {
            this.edgeId = Objects.requireNonNull(edgeId, "edgeId is required");
            this.matchType = Objects.requireNonNull(matchType, "matchType is required");
            this.match = Objects.requireNonNull(match, "match is required");
        }

        public CreateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public CreateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CreateCallBuilder backend(EndpointBackendMutate backend) {
            this.backend = Optional.of(Objects.requireNonNull(backend, "backend is required"));
            return this;
        }

        public CreateCallBuilder backend(Optional<EndpointBackendMutate> backend) {
            this.backend = Objects.requireNonNull(backend, "backend is required");
            return this;
        }

        public CreateCallBuilder ipRestriction(EndpointIpPolicyMutate ipRestriction) {
            this.ipRestriction = Optional.of(Objects.requireNonNull(ipRestriction, "ipRestriction is required"));
            return this;
        }

        public CreateCallBuilder ipRestriction(Optional<EndpointIpPolicyMutate> ipRestriction) {
            this.ipRestriction = Objects.requireNonNull(ipRestriction, "ipRestriction is required");
            return this;
        }

        public CreateCallBuilder circuitBreaker(EndpointCircuitBreaker circuitBreaker) {
            this.circuitBreaker = Optional.of(Objects.requireNonNull(circuitBreaker, "circuitBreaker is required"));
            return this;
        }

        public CreateCallBuilder circuitBreaker(Optional<EndpointCircuitBreaker> circuitBreaker) {
            this.circuitBreaker = Objects.requireNonNull(circuitBreaker, "circuitBreaker is required");
            return this;
        }

        public CreateCallBuilder compression(EndpointCompression compression) {
            this.compression = Optional.of(Objects.requireNonNull(compression, "compression is required"));
            return this;
        }

        public CreateCallBuilder compression(Optional<EndpointCompression> compression) {
            this.compression = Objects.requireNonNull(compression, "compression is required");
            return this;
        }

        public CreateCallBuilder requestHeaders(EndpointRequestHeaders requestHeaders) {
            this.requestHeaders = Optional.of(Objects.requireNonNull(requestHeaders, "requestHeaders is required"));
            return this;
        }

        public CreateCallBuilder requestHeaders(Optional<EndpointRequestHeaders> requestHeaders) {
            this.requestHeaders = Objects.requireNonNull(requestHeaders, "requestHeaders is required");
            return this;
        }

        public CreateCallBuilder responseHeaders(EndpointResponseHeaders responseHeaders) {
            this.responseHeaders = Optional.of(Objects.requireNonNull(responseHeaders, "responseHeaders is required"));
            return this;
        }

        public CreateCallBuilder responseHeaders(Optional<EndpointResponseHeaders> responseHeaders) {
            this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders is required");
            return this;
        }

        public CreateCallBuilder webhookVerification(EndpointWebhookValidation webhookVerification) {
            this.webhookVerification = Optional.of(Objects.requireNonNull(webhookVerification, "webhookVerification is required"));
            return this;
        }

        public CreateCallBuilder webhookVerification(Optional<EndpointWebhookValidation> webhookVerification) {
            this.webhookVerification = Objects.requireNonNull(webhookVerification, "webhookVerification is required");
            return this;
        }

        public CreateCallBuilder oauth(EndpointOAuth oauth) {
            this.oauth = Optional.of(Objects.requireNonNull(oauth, "oauth is required"));
            return this;
        }

        public CreateCallBuilder oauth(Optional<EndpointOAuth> oauth) {
            this.oauth = Objects.requireNonNull(oauth, "oauth is required");
            return this;
        }

        public CreateCallBuilder saml(EndpointSamlMutate saml) {
            this.saml = Optional.of(Objects.requireNonNull(saml, "saml is required"));
            return this;
        }

        public CreateCallBuilder saml(Optional<EndpointSamlMutate> saml) {
            this.saml = Objects.requireNonNull(saml, "saml is required");
            return this;
        }

        public CreateCallBuilder oidc(EndpointOidc oidc) {
            this.oidc = Optional.of(Objects.requireNonNull(oidc, "oidc is required"));
            return this;
        }

        public CreateCallBuilder oidc(Optional<EndpointOidc> oidc) {
            this.oidc = Objects.requireNonNull(oidc, "oidc is required");
            return this;
        }

        public CreateCallBuilder websocketTcpConverter(EndpointWebsocketTcpConverter websocketTcpConverter) {
            this.websocketTcpConverter = Optional.of(Objects.requireNonNull(websocketTcpConverter, "websocketTcpConverter is required"));
            return this;
        }

        public CreateCallBuilder websocketTcpConverter(Optional<EndpointWebsocketTcpConverter> websocketTcpConverter) {
            this.websocketTcpConverter = Objects.requireNonNull(websocketTcpConverter, "websocketTcpConverter is required");
            return this;
        }

        public CompletionStage<HttpsEdgeRoute> call() {
            return EdgesHttpsRoutes.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/edges/https/" + this.edgeId + "/routes", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry<String, Optional<String>>("match_type", Optional.of(this.matchType)), new AbstractMap.SimpleEntry<String, Optional<String>>("match", Optional.of(this.match)), new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("backend", this.backend.map(Function.identity())), new AbstractMap.SimpleEntry("ip_restriction", this.ipRestriction.map(Function.identity())), new AbstractMap.SimpleEntry("circuit_breaker", this.circuitBreaker.map(Function.identity())), new AbstractMap.SimpleEntry("compression", this.compression.map(Function.identity())), new AbstractMap.SimpleEntry("request_headers", this.requestHeaders.map(Function.identity())), new AbstractMap.SimpleEntry("response_headers", this.responseHeaders.map(Function.identity())), new AbstractMap.SimpleEntry("webhook_verification", this.webhookVerification.map(Function.identity())), new AbstractMap.SimpleEntry("oauth", this.oauth.map(Function.identity())), new AbstractMap.SimpleEntry("saml", this.saml.map(Function.identity())), new AbstractMap.SimpleEntry("oidc", this.oidc.map(Function.identity())), new AbstractMap.SimpleEntry("websocket_tcp_converter", this.websocketTcpConverter.map(Function.identity()))), Optional.of(HttpsEdgeRoute.class));
        }

        public HttpsEdgeRoute blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String edgeId;
        private final String id;

        private GetCallBuilder(String edgeId, String id) {
            this.edgeId = Objects.requireNonNull(edgeId, "edgeId is required");
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<HttpsEdgeRoute> call() {
            return EdgesHttpsRoutes.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/edges/https/" + this.edgeId + "/routes/" + this.id, Stream.empty(), Stream.empty(), Optional.of(HttpsEdgeRoute.class));
        }

        public HttpsEdgeRoute blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class UpdateCallBuilder {
        private final String edgeId;
        private final String id;
        private Optional<String> matchType = Optional.empty();
        private Optional<String> match = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> metadata = Optional.empty();
        private Optional<EndpointBackendMutate> backend = Optional.empty();
        private Optional<EndpointIpPolicyMutate> ipRestriction = Optional.empty();
        private Optional<EndpointCircuitBreaker> circuitBreaker = Optional.empty();
        private Optional<EndpointCompression> compression = Optional.empty();
        private Optional<EndpointRequestHeaders> requestHeaders = Optional.empty();
        private Optional<EndpointResponseHeaders> responseHeaders = Optional.empty();
        private Optional<EndpointWebhookValidation> webhookVerification = Optional.empty();
        private Optional<EndpointOAuth> oauth = Optional.empty();
        private Optional<EndpointSamlMutate> saml = Optional.empty();
        private Optional<EndpointOidc> oidc = Optional.empty();
        private Optional<EndpointWebsocketTcpConverter> websocketTcpConverter = Optional.empty();

        private UpdateCallBuilder(String edgeId, String id) {
            this.edgeId = Objects.requireNonNull(edgeId, "edgeId is required");
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public UpdateCallBuilder matchType(String matchType) {
            this.matchType = Optional.of(Objects.requireNonNull(matchType, "matchType is required"));
            return this;
        }

        public UpdateCallBuilder matchType(Optional<String> matchType) {
            this.matchType = Objects.requireNonNull(matchType, "matchType is required");
            return this;
        }

        public UpdateCallBuilder match(String match) {
            this.match = Optional.of(Objects.requireNonNull(match, "match is required"));
            return this;
        }

        public UpdateCallBuilder match(Optional<String> match) {
            this.match = Objects.requireNonNull(match, "match is required");
            return this;
        }

        public UpdateCallBuilder description(String description) {
            this.description = Optional.of(Objects.requireNonNull(description, "description is required"));
            return this;
        }

        public UpdateCallBuilder description(Optional<String> description) {
            this.description = Objects.requireNonNull(description, "description is required");
            return this;
        }

        public UpdateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public UpdateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public UpdateCallBuilder backend(EndpointBackendMutate backend) {
            this.backend = Optional.of(Objects.requireNonNull(backend, "backend is required"));
            return this;
        }

        public UpdateCallBuilder backend(Optional<EndpointBackendMutate> backend) {
            this.backend = Objects.requireNonNull(backend, "backend is required");
            return this;
        }

        public UpdateCallBuilder ipRestriction(EndpointIpPolicyMutate ipRestriction) {
            this.ipRestriction = Optional.of(Objects.requireNonNull(ipRestriction, "ipRestriction is required"));
            return this;
        }

        public UpdateCallBuilder ipRestriction(Optional<EndpointIpPolicyMutate> ipRestriction) {
            this.ipRestriction = Objects.requireNonNull(ipRestriction, "ipRestriction is required");
            return this;
        }

        public UpdateCallBuilder circuitBreaker(EndpointCircuitBreaker circuitBreaker) {
            this.circuitBreaker = Optional.of(Objects.requireNonNull(circuitBreaker, "circuitBreaker is required"));
            return this;
        }

        public UpdateCallBuilder circuitBreaker(Optional<EndpointCircuitBreaker> circuitBreaker) {
            this.circuitBreaker = Objects.requireNonNull(circuitBreaker, "circuitBreaker is required");
            return this;
        }

        public UpdateCallBuilder compression(EndpointCompression compression) {
            this.compression = Optional.of(Objects.requireNonNull(compression, "compression is required"));
            return this;
        }

        public UpdateCallBuilder compression(Optional<EndpointCompression> compression) {
            this.compression = Objects.requireNonNull(compression, "compression is required");
            return this;
        }

        public UpdateCallBuilder requestHeaders(EndpointRequestHeaders requestHeaders) {
            this.requestHeaders = Optional.of(Objects.requireNonNull(requestHeaders, "requestHeaders is required"));
            return this;
        }

        public UpdateCallBuilder requestHeaders(Optional<EndpointRequestHeaders> requestHeaders) {
            this.requestHeaders = Objects.requireNonNull(requestHeaders, "requestHeaders is required");
            return this;
        }

        public UpdateCallBuilder responseHeaders(EndpointResponseHeaders responseHeaders) {
            this.responseHeaders = Optional.of(Objects.requireNonNull(responseHeaders, "responseHeaders is required"));
            return this;
        }

        public UpdateCallBuilder responseHeaders(Optional<EndpointResponseHeaders> responseHeaders) {
            this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders is required");
            return this;
        }

        public UpdateCallBuilder webhookVerification(EndpointWebhookValidation webhookVerification) {
            this.webhookVerification = Optional.of(Objects.requireNonNull(webhookVerification, "webhookVerification is required"));
            return this;
        }

        public UpdateCallBuilder webhookVerification(Optional<EndpointWebhookValidation> webhookVerification) {
            this.webhookVerification = Objects.requireNonNull(webhookVerification, "webhookVerification is required");
            return this;
        }

        public UpdateCallBuilder oauth(EndpointOAuth oauth) {
            this.oauth = Optional.of(Objects.requireNonNull(oauth, "oauth is required"));
            return this;
        }

        public UpdateCallBuilder oauth(Optional<EndpointOAuth> oauth) {
            this.oauth = Objects.requireNonNull(oauth, "oauth is required");
            return this;
        }

        public UpdateCallBuilder saml(EndpointSamlMutate saml) {
            this.saml = Optional.of(Objects.requireNonNull(saml, "saml is required"));
            return this;
        }

        public UpdateCallBuilder saml(Optional<EndpointSamlMutate> saml) {
            this.saml = Objects.requireNonNull(saml, "saml is required");
            return this;
        }

        public UpdateCallBuilder oidc(EndpointOidc oidc) {
            this.oidc = Optional.of(Objects.requireNonNull(oidc, "oidc is required"));
            return this;
        }

        public UpdateCallBuilder oidc(Optional<EndpointOidc> oidc) {
            this.oidc = Objects.requireNonNull(oidc, "oidc is required");
            return this;
        }

        public UpdateCallBuilder websocketTcpConverter(EndpointWebsocketTcpConverter websocketTcpConverter) {
            this.websocketTcpConverter = Optional.of(Objects.requireNonNull(websocketTcpConverter, "websocketTcpConverter is required"));
            return this;
        }

        public UpdateCallBuilder websocketTcpConverter(Optional<EndpointWebsocketTcpConverter> websocketTcpConverter) {
            this.websocketTcpConverter = Objects.requireNonNull(websocketTcpConverter, "websocketTcpConverter is required");
            return this;
        }

        public CompletionStage<HttpsEdgeRoute> call() {
            return EdgesHttpsRoutes.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PATCH, "/edges/https/" + this.edgeId + "/routes/" + this.id, Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("match_type", this.matchType.map(Function.identity())), new AbstractMap.SimpleEntry("match", this.match.map(Function.identity())), new AbstractMap.SimpleEntry("description", this.description.map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity())), new AbstractMap.SimpleEntry("backend", this.backend.map(Function.identity())), new AbstractMap.SimpleEntry("ip_restriction", this.ipRestriction.map(Function.identity())), new AbstractMap.SimpleEntry("circuit_breaker", this.circuitBreaker.map(Function.identity())), new AbstractMap.SimpleEntry("compression", this.compression.map(Function.identity())), new AbstractMap.SimpleEntry("request_headers", this.requestHeaders.map(Function.identity())), new AbstractMap.SimpleEntry("response_headers", this.responseHeaders.map(Function.identity())), new AbstractMap.SimpleEntry("webhook_verification", this.webhookVerification.map(Function.identity())), new AbstractMap.SimpleEntry("oauth", this.oauth.map(Function.identity())), new AbstractMap.SimpleEntry("saml", this.saml.map(Function.identity())), new AbstractMap.SimpleEntry("oidc", this.oidc.map(Function.identity())), new AbstractMap.SimpleEntry("websocket_tcp_converter", this.websocketTcpConverter.map(Function.identity()))), Optional.of(HttpsEdgeRoute.class));
        }

        public HttpsEdgeRoute blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String edgeId;
        private final String id;

        private DeleteCallBuilder(String edgeId, String id) {
            this.edgeId = Objects.requireNonNull(edgeId, "edgeId is required");
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return EdgesHttpsRoutes.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/edges/https/" + this.edgeId + "/routes/" + this.id, Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

