/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.EndpointRequestHeaders;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class EdgeRouteRequestHeadersModule {
    private final NgrokApiClient apiClient;

    public EdgeRouteRequestHeadersModule(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public ReplaceCallBuilder replace(String edgeId, String id) {
        return new ReplaceCallBuilder(edgeId, id);
    }

    public GetCallBuilder get(String edgeId, String id) {
        return new GetCallBuilder(edgeId, id);
    }

    public DeleteCallBuilder delete(String edgeId, String id) {
        return new DeleteCallBuilder(edgeId, id);
    }

    public class ReplaceCallBuilder {
        private final String edgeId;
        private final String id;
        private Optional<EndpointRequestHeaders> module = Optional.empty();

        private ReplaceCallBuilder(String edgeId, String id) {
            this.edgeId = Objects.requireNonNull(edgeId, "edgeId is required");
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public ReplaceCallBuilder module(EndpointRequestHeaders module) {
            this.module = Optional.of(Objects.requireNonNull(module, "module is required"));
            return this;
        }

        public ReplaceCallBuilder module(Optional<EndpointRequestHeaders> module) {
            this.module = Objects.requireNonNull(module, "module is required");
            return this;
        }

        public CompletionStage<EndpointRequestHeaders> call() {
            return EdgeRouteRequestHeadersModule.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.PUT, "/edges/https/" + this.edgeId + "/routes/" + this.id + "/request_headers", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("module", this.module.map(Function.identity()))), Optional.of(EndpointRequestHeaders.class));
        }

        public EndpointRequestHeaders blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String edgeId;
        private final String id;

        private GetCallBuilder(String edgeId, String id) {
            this.edgeId = Objects.requireNonNull(edgeId, "edgeId is required");
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<EndpointRequestHeaders> call() {
            return EdgeRouteRequestHeadersModule.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/edges/https/" + this.edgeId + "/routes/" + this.id + "/request_headers", Stream.empty(), Stream.empty(), Optional.of(EndpointRequestHeaders.class));
        }

        public EndpointRequestHeaders blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class DeleteCallBuilder {
        private final String edgeId;
        private final String id;

        private DeleteCallBuilder(String edgeId, String id) {
            this.edgeId = Objects.requireNonNull(edgeId, "edgeId is required");
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<Void> call() {
            return EdgeRouteRequestHeadersModule.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.DELETE, "/edges/https/" + this.edgeId + "/routes/" + this.id + "/request_headers", Stream.empty(), Stream.empty(), Optional.empty());
        }

        public void blockingCall() throws InterruptedException {
            try {
                this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

