/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.services;

import com.ngrok.NgrokApiClient;
import com.ngrok.definitions.AbuseReport;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;

public class AbuseReports {
    private final NgrokApiClient apiClient;

    public AbuseReports(NgrokApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient is required");
    }

    public CreateCallBuilder create(List<URI> urls) {
        return new CreateCallBuilder(urls);
    }

    public GetCallBuilder get(String id) {
        return new GetCallBuilder(id);
    }

    public class CreateCallBuilder {
        private List<URI> urls = Collections.emptyList();
        private Optional<String> metadata = Optional.empty();

        private CreateCallBuilder(List<URI> urls) {
            this.urls = Objects.requireNonNull(urls, "urls is required");
        }

        public CreateCallBuilder metadata(String metadata) {
            this.metadata = Optional.of(Objects.requireNonNull(metadata, "metadata is required"));
            return this;
        }

        public CreateCallBuilder metadata(Optional<String> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is required");
            return this;
        }

        public CompletionStage<AbuseReport> call() {
            return AbuseReports.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.POST, "/abuse_reports", Stream.empty(), Stream.of(new AbstractMap.SimpleEntry("urls", Optional.of(this.urls).filter(urls -> !urls.isEmpty()).map(Function.identity())), new AbstractMap.SimpleEntry("metadata", this.metadata.map(Function.identity()))), Optional.of(AbuseReport.class));
        }

        public AbuseReport blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    public class GetCallBuilder {
        private final String id;

        private GetCallBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is required");
        }

        public CompletionStage<AbuseReport> call() {
            return AbuseReports.this.apiClient.sendRequest(NgrokApiClient.HttpMethod.GET, "/abuse_reports/" + this.id, Stream.empty(), Stream.empty(), Optional.of(AbuseReport.class));
        }

        public AbuseReport blockingCall() throws InterruptedException {
            try {
                return this.call().toCompletableFuture().get();
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

