/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.Ref;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Tunnel {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String id;
    @JsonProperty(value="public_url")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI publicUrl;
    @JsonProperty(value="started_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime startedAt;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String metadata;
    @JsonProperty(value="proto")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String proto;
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String region;
    @JsonProperty(value="tunnel_session")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Ref tunnelSession;
    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Ref> endpoint;
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Map<String, String> labels;
    @JsonProperty(value="backends")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<List<Ref>> backends;
    @JsonProperty(value="forwards_to")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String forwardsTo;

    @JsonCreator
    public Tunnel(@JsonProperty(value="id") String id, @JsonProperty(value="public_url") URI publicUrl, @JsonProperty(value="started_at") OffsetDateTime startedAt, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="proto") String proto, @JsonProperty(value="region") String region, @JsonProperty(value="tunnel_session") Ref tunnelSession, @JsonProperty(value="endpoint") Optional<Ref> endpoint, @JsonProperty(value="labels") Map<String, String> labels, @JsonProperty(value="backends") Optional<List<Ref>> backends, @JsonProperty(value="forwards_to") String forwardsTo) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.publicUrl = Objects.requireNonNull(publicUrl, "publicUrl is required");
        this.startedAt = Objects.requireNonNull(startedAt, "startedAt is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.proto = Objects.requireNonNull(proto, "proto is required");
        this.region = Objects.requireNonNull(region, "region is required");
        this.tunnelSession = Objects.requireNonNull(tunnelSession, "tunnelSession is required");
        this.endpoint = endpoint != null ? endpoint : Optional.empty();
        this.labels = labels != null ? labels : Collections.emptyMap();
        this.backends = backends != null ? backends : Optional.empty();
        this.forwardsTo = Objects.requireNonNull(forwardsTo, "forwardsTo is required");
    }

    public String getId() {
        return this.id;
    }

    public URI getPublicUrl() {
        return this.publicUrl;
    }

    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getProto() {
        return this.proto;
    }

    public String getRegion() {
        return this.region;
    }

    public Ref getTunnelSession() {
        return this.tunnelSession;
    }

    public Optional<Ref> getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Optional<List<Ref>> getBackends() {
        return this.backends;
    }

    public String getForwardsTo() {
        return this.forwardsTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tunnel other = (Tunnel)o;
        return this.id.equals(other.id) && this.publicUrl.equals(other.publicUrl) && this.startedAt.equals(other.startedAt) && this.metadata.equals(other.metadata) && this.proto.equals(other.proto) && this.region.equals(other.region) && this.tunnelSession.equals(other.tunnelSession) && this.endpoint.equals(other.endpoint) && this.labels.equals(other.labels) && this.backends.equals(other.backends) && this.forwardsTo.equals(other.forwardsTo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.publicUrl, this.startedAt, this.metadata, this.proto, this.region, this.tunnelSession, this.endpoint, this.labels, this.backends, this.forwardsTo);
    }

    public String toString() {
        return "Tunnel{id='" + this.id + "', publicUrl='" + this.publicUrl + "', startedAt='" + this.startedAt + "', metadata='" + this.metadata + "', proto='" + this.proto + "', region='" + this.region + "', tunnelSession='" + this.tunnelSession + "', endpoint='" + this.endpoint.map(Object::toString).orElse("(null)") + "', labels='" + this.labels + "', backends='" + this.backends.map(Object::toString).orElse("(null)") + "', forwardsTo='" + this.forwardsTo + "'}";
    }
}

