/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EndpointBackend;
import com.ngrok.definitions.EndpointIpPolicy;
import com.ngrok.definitions.EndpointMutualTls;
import com.ngrok.definitions.EndpointTlsTermination;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TlsEdge {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String id;
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String description;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String metadata;
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime createdAt;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="hostports")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<List<String>> hostports;
    @JsonProperty(value="backend")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointBackend> backend;
    @JsonProperty(value="ip_restriction")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointIpPolicy> ipRestriction;
    @JsonProperty(value="mutual_tls")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointMutualTls> mutualTls;
    @JsonProperty(value="tls_termination")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointTlsTermination> tlsTermination;

    @JsonCreator
    public TlsEdge(@JsonProperty(value="id") String id, @JsonProperty(value="description") String description, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="uri") URI uri, @JsonProperty(value="hostports") Optional<List<String>> hostports, @JsonProperty(value="backend") Optional<EndpointBackend> backend, @JsonProperty(value="ip_restriction") Optional<EndpointIpPolicy> ipRestriction, @JsonProperty(value="mutual_tls") Optional<EndpointMutualTls> mutualTls, @JsonProperty(value="tls_termination") Optional<EndpointTlsTermination> tlsTermination) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.description = Objects.requireNonNull(description, "description is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt is required");
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.hostports = hostports != null ? hostports : Optional.empty();
        this.backend = backend != null ? backend : Optional.empty();
        this.ipRestriction = ipRestriction != null ? ipRestriction : Optional.empty();
        this.mutualTls = mutualTls != null ? mutualTls : Optional.empty();
        this.tlsTermination = tlsTermination != null ? tlsTermination : Optional.empty();
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public URI getUri() {
        return this.uri;
    }

    public Optional<List<String>> getHostports() {
        return this.hostports;
    }

    public Optional<EndpointBackend> getBackend() {
        return this.backend;
    }

    public Optional<EndpointIpPolicy> getIpRestriction() {
        return this.ipRestriction;
    }

    public Optional<EndpointMutualTls> getMutualTls() {
        return this.mutualTls;
    }

    public Optional<EndpointTlsTermination> getTlsTermination() {
        return this.tlsTermination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TlsEdge other = (TlsEdge)o;
        return this.id.equals(other.id) && this.description.equals(other.description) && this.metadata.equals(other.metadata) && this.createdAt.equals(other.createdAt) && this.uri.equals(other.uri) && this.hostports.equals(other.hostports) && this.backend.equals(other.backend) && this.ipRestriction.equals(other.ipRestriction) && this.mutualTls.equals(other.mutualTls) && this.tlsTermination.equals(other.tlsTermination);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.metadata, this.createdAt, this.uri, this.hostports, this.backend, this.ipRestriction, this.mutualTls, this.tlsTermination);
    }

    public String toString() {
        return "TlsEdge{id='" + this.id + "', description='" + this.description + "', metadata='" + this.metadata + "', createdAt='" + this.createdAt + "', uri='" + this.uri + "', hostports='" + this.hostports.map(Object::toString).orElse("(null)") + "', backend='" + this.backend.map(Object::toString).orElse("(null)") + "', ipRestriction='" + this.ipRestriction.map(Object::toString).orElse("(null)") + "', mutualTls='" + this.mutualTls.map(Object::toString).orElse("(null)") + "', tlsTermination='" + this.tlsTermination.map(Object::toString).orElse("(null)") + "'}";
    }
}

