/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.TlsCertificateSaNs;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TlsCertificate {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String id;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime createdAt;
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String description;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String metadata;
    @JsonProperty(value="certificate_pem")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String certificatePem;
    @JsonProperty(value="subject_common_name")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String subjectCommonName;
    @JsonProperty(value="subject_alternative_names")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final TlsCertificateSaNs subjectAlternativeNames;
    @JsonProperty(value="issued_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<OffsetDateTime> issuedAt;
    @JsonProperty(value="not_before")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime notBefore;
    @JsonProperty(value="not_after")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime notAfter;
    @JsonProperty(value="key_usages")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> keyUsages;
    @JsonProperty(value="extended_key_usages")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<String> extendedKeyUsages;
    @JsonProperty(value="private_key_type")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String privateKeyType;
    @JsonProperty(value="issuer_common_name")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String issuerCommonName;
    @JsonProperty(value="serial_number")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String serialNumber;
    @JsonProperty(value="subject_organization")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String subjectOrganization;
    @JsonProperty(value="subject_organizational_unit")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String subjectOrganizationalUnit;
    @JsonProperty(value="subject_locality")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String subjectLocality;
    @JsonProperty(value="subject_province")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String subjectProvince;
    @JsonProperty(value="subject_country")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String subjectCountry;

    @JsonCreator
    public TlsCertificate(@JsonProperty(value="id") String id, @JsonProperty(value="uri") URI uri, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="description") String description, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="certificate_pem") String certificatePem, @JsonProperty(value="subject_common_name") String subjectCommonName, @JsonProperty(value="subject_alternative_names") TlsCertificateSaNs subjectAlternativeNames, @JsonProperty(value="issued_at") Optional<OffsetDateTime> issuedAt, @JsonProperty(value="not_before") OffsetDateTime notBefore, @JsonProperty(value="not_after") OffsetDateTime notAfter, @JsonProperty(value="key_usages") List<String> keyUsages, @JsonProperty(value="extended_key_usages") List<String> extendedKeyUsages, @JsonProperty(value="private_key_type") String privateKeyType, @JsonProperty(value="issuer_common_name") String issuerCommonName, @JsonProperty(value="serial_number") String serialNumber, @JsonProperty(value="subject_organization") String subjectOrganization, @JsonProperty(value="subject_organizational_unit") String subjectOrganizationalUnit, @JsonProperty(value="subject_locality") String subjectLocality, @JsonProperty(value="subject_province") String subjectProvince, @JsonProperty(value="subject_country") String subjectCountry) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt is required");
        this.description = Objects.requireNonNull(description, "description is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.certificatePem = Objects.requireNonNull(certificatePem, "certificatePem is required");
        this.subjectCommonName = Objects.requireNonNull(subjectCommonName, "subjectCommonName is required");
        this.subjectAlternativeNames = Objects.requireNonNull(subjectAlternativeNames, "subjectAlternativeNames is required");
        this.issuedAt = issuedAt != null ? issuedAt : Optional.empty();
        this.notBefore = Objects.requireNonNull(notBefore, "notBefore is required");
        this.notAfter = Objects.requireNonNull(notAfter, "notAfter is required");
        this.keyUsages = keyUsages != null ? keyUsages : Collections.emptyList();
        this.extendedKeyUsages = extendedKeyUsages != null ? extendedKeyUsages : Collections.emptyList();
        this.privateKeyType = Objects.requireNonNull(privateKeyType, "privateKeyType is required");
        this.issuerCommonName = Objects.requireNonNull(issuerCommonName, "issuerCommonName is required");
        this.serialNumber = Objects.requireNonNull(serialNumber, "serialNumber is required");
        this.subjectOrganization = Objects.requireNonNull(subjectOrganization, "subjectOrganization is required");
        this.subjectOrganizationalUnit = Objects.requireNonNull(subjectOrganizationalUnit, "subjectOrganizationalUnit is required");
        this.subjectLocality = Objects.requireNonNull(subjectLocality, "subjectLocality is required");
        this.subjectProvince = Objects.requireNonNull(subjectProvince, "subjectProvince is required");
        this.subjectCountry = Objects.requireNonNull(subjectCountry, "subjectCountry is required");
    }

    public String getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getCertificatePem() {
        return this.certificatePem;
    }

    public String getSubjectCommonName() {
        return this.subjectCommonName;
    }

    public TlsCertificateSaNs getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public Optional<OffsetDateTime> getIssuedAt() {
        return this.issuedAt;
    }

    public OffsetDateTime getNotBefore() {
        return this.notBefore;
    }

    public OffsetDateTime getNotAfter() {
        return this.notAfter;
    }

    public List<String> getKeyUsages() {
        return this.keyUsages;
    }

    public List<String> getExtendedKeyUsages() {
        return this.extendedKeyUsages;
    }

    public String getPrivateKeyType() {
        return this.privateKeyType;
    }

    public String getIssuerCommonName() {
        return this.issuerCommonName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getSubjectOrganization() {
        return this.subjectOrganization;
    }

    public String getSubjectOrganizationalUnit() {
        return this.subjectOrganizationalUnit;
    }

    public String getSubjectLocality() {
        return this.subjectLocality;
    }

    public String getSubjectProvince() {
        return this.subjectProvince;
    }

    public String getSubjectCountry() {
        return this.subjectCountry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TlsCertificate other = (TlsCertificate)o;
        return this.id.equals(other.id) && this.uri.equals(other.uri) && this.createdAt.equals(other.createdAt) && this.description.equals(other.description) && this.metadata.equals(other.metadata) && this.certificatePem.equals(other.certificatePem) && this.subjectCommonName.equals(other.subjectCommonName) && this.subjectAlternativeNames.equals(other.subjectAlternativeNames) && this.issuedAt.equals(other.issuedAt) && this.notBefore.equals(other.notBefore) && this.notAfter.equals(other.notAfter) && this.keyUsages.equals(other.keyUsages) && this.extendedKeyUsages.equals(other.extendedKeyUsages) && this.privateKeyType.equals(other.privateKeyType) && this.issuerCommonName.equals(other.issuerCommonName) && this.serialNumber.equals(other.serialNumber) && this.subjectOrganization.equals(other.subjectOrganization) && this.subjectOrganizationalUnit.equals(other.subjectOrganizationalUnit) && this.subjectLocality.equals(other.subjectLocality) && this.subjectProvince.equals(other.subjectProvince) && this.subjectCountry.equals(other.subjectCountry);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri, this.createdAt, this.description, this.metadata, this.certificatePem, this.subjectCommonName, this.subjectAlternativeNames, this.issuedAt, this.notBefore, this.notAfter, this.keyUsages, this.extendedKeyUsages, this.privateKeyType, this.issuerCommonName, this.serialNumber, this.subjectOrganization, this.subjectOrganizationalUnit, this.subjectLocality, this.subjectProvince, this.subjectCountry);
    }

    public String toString() {
        return "TlsCertificate{id='" + this.id + "', uri='" + this.uri + "', createdAt='" + this.createdAt + "', description='" + this.description + "', metadata='" + this.metadata + "', certificatePem='" + this.certificatePem + "', subjectCommonName='" + this.subjectCommonName + "', subjectAlternativeNames='" + this.subjectAlternativeNames + "', issuedAt='" + this.issuedAt.map(Object::toString).orElse("(null)") + "', notBefore='" + this.notBefore + "', notAfter='" + this.notAfter + "', keyUsages='" + this.keyUsages + "', extendedKeyUsages='" + this.extendedKeyUsages + "', privateKeyType='" + this.privateKeyType + "', issuerCommonName='" + this.issuerCommonName + "', serialNumber='" + this.serialNumber + "', subjectOrganization='" + this.subjectOrganization + "', subjectOrganizationalUnit='" + this.subjectOrganizationalUnit + "', subjectLocality='" + this.subjectLocality + "', subjectProvince='" + this.subjectProvince + "', subjectCountry='" + this.subjectCountry + "'}";
    }
}

