/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.Pageable;
import com.ngrok.definitions.TcpEdge;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TcpEdgeList
implements Pageable {
    @JsonProperty(value="tcp_edges")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<TcpEdge> tcpEdges;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="next_page_uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<URI> nextPageUri;

    @JsonCreator
    public TcpEdgeList(@JsonProperty(value="tcp_edges") List<TcpEdge> tcpEdges, @JsonProperty(value="uri") URI uri, @JsonProperty(value="next_page_uri") Optional<URI> nextPageUri) {
        this.tcpEdges = tcpEdges != null ? tcpEdges : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.nextPageUri = nextPageUri != null ? nextPageUri : Optional.empty();
    }

    public List<TcpEdge> getTcpEdges() {
        return this.tcpEdges;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Optional<URI> getNextPageUri() {
        return this.nextPageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpEdgeList other = (TcpEdgeList)o;
        return this.tcpEdges.equals(other.tcpEdges) && this.uri.equals(other.uri) && this.nextPageUri.equals(other.nextPageUri);
    }

    public int hashCode() {
        return Objects.hash(this.tcpEdges, this.uri, this.nextPageUri);
    }

    public String toString() {
        return "TcpEdgeList{tcpEdges='" + this.tcpEdges + "', uri='" + this.uri + "', nextPageUri='" + this.nextPageUri.map(Object::toString).orElse("(null)") + "'}";
    }
}

