/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.Pageable;
import com.ngrok.definitions.SshUserCertificate;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SshUserCertificateList
implements Pageable {
    @JsonProperty(value="ssh_user_certificates")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<SshUserCertificate> sshUserCertificates;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="next_page_uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<URI> nextPageUri;

    @JsonCreator
    public SshUserCertificateList(@JsonProperty(value="ssh_user_certificates") List<SshUserCertificate> sshUserCertificates, @JsonProperty(value="uri") URI uri, @JsonProperty(value="next_page_uri") Optional<URI> nextPageUri) {
        this.sshUserCertificates = sshUserCertificates != null ? sshUserCertificates : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.nextPageUri = nextPageUri != null ? nextPageUri : Optional.empty();
    }

    public List<SshUserCertificate> getSshUserCertificates() {
        return this.sshUserCertificates;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Optional<URI> getNextPageUri() {
        return this.nextPageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshUserCertificateList other = (SshUserCertificateList)o;
        return this.sshUserCertificates.equals(other.sshUserCertificates) && this.uri.equals(other.uri) && this.nextPageUri.equals(other.nextPageUri);
    }

    public int hashCode() {
        return Objects.hash(this.sshUserCertificates, this.uri, this.nextPageUri);
    }

    public String toString() {
        return "SshUserCertificateList{sshUserCertificates='" + this.sshUserCertificates + "', uri='" + this.uri + "', nextPageUri='" + this.nextPageUri.map(Object::toString).orElse("(null)") + "'}";
    }
}

