/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.Pageable;
import com.ngrok.definitions.SshCertificateAuthority;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SshCertificateAuthorityList
implements Pageable {
    @JsonProperty(value="ssh_certificate_authorities")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<SshCertificateAuthority> sshCertificateAuthorities;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="next_page_uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<URI> nextPageUri;

    @JsonCreator
    public SshCertificateAuthorityList(@JsonProperty(value="ssh_certificate_authorities") List<SshCertificateAuthority> sshCertificateAuthorities, @JsonProperty(value="uri") URI uri, @JsonProperty(value="next_page_uri") Optional<URI> nextPageUri) {
        this.sshCertificateAuthorities = sshCertificateAuthorities != null ? sshCertificateAuthorities : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.nextPageUri = nextPageUri != null ? nextPageUri : Optional.empty();
    }

    public List<SshCertificateAuthority> getSshCertificateAuthorities() {
        return this.sshCertificateAuthorities;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Optional<URI> getNextPageUri() {
        return this.nextPageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshCertificateAuthorityList other = (SshCertificateAuthorityList)o;
        return this.sshCertificateAuthorities.equals(other.sshCertificateAuthorities) && this.uri.equals(other.uri) && this.nextPageUri.equals(other.nextPageUri);
    }

    public int hashCode() {
        return Objects.hash(this.sshCertificateAuthorities, this.uri, this.nextPageUri);
    }

    public String toString() {
        return "SshCertificateAuthorityList{sshCertificateAuthorities='" + this.sshCertificateAuthorities + "', uri='" + this.uri + "', nextPageUri='" + this.nextPageUri.map(Object::toString).orElse("(null)") + "'}";
    }
}

