/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReservedDomainCertPolicy {
    @JsonProperty(value="authority")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String authority;
    @JsonProperty(value="private_key_type")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String privateKeyType;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private ReservedDomainCertPolicy(@JsonProperty(value="authority") String authority, @JsonProperty(value="private_key_type") String privateKeyType) {
        this.authority = Objects.requireNonNull(authority, "authority is required");
        this.privateKeyType = Objects.requireNonNull(privateKeyType, "privateKeyType is required");
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getPrivateKeyType() {
        return this.privateKeyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReservedDomainCertPolicy other = (ReservedDomainCertPolicy)o;
        return this.authority.equals(other.authority) && this.privateKeyType.equals(other.privateKeyType);
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.privateKeyType);
    }

    public String toString() {
        return "ReservedDomainCertPolicy{authority='" + this.authority + "', privateKeyType='" + this.privateKeyType + "'}";
    }

    public static class Builder {
        private Optional<String> authority = Optional.empty();
        private Optional<String> privateKeyType = Optional.empty();

        private Builder() {
        }

        public Builder authority(String authority) {
            this.authority = Optional.of(Objects.requireNonNull(authority, "authority is required"));
            return this;
        }

        public Builder authority(Optional<String> authority) {
            this.authority = Objects.requireNonNull(authority, "authority is required");
            return this;
        }

        public Builder privateKeyType(String privateKeyType) {
            this.privateKeyType = Optional.of(Objects.requireNonNull(privateKeyType, "privateKeyType is required"));
            return this;
        }

        public Builder privateKeyType(Optional<String> privateKeyType) {
            this.privateKeyType = Objects.requireNonNull(privateKeyType, "privateKeyType is required");
            return this;
        }

        public ReservedDomainCertPolicy build() {
            return new ReservedDomainCertPolicy(this.authority.orElse(""), this.privateKeyType.orElse(""));
        }
    }
}

