/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.Ref;
import com.ngrok.definitions.ReservedDomainCertPolicy;
import com.ngrok.definitions.ReservedDomainCertStatus;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReservedDomain {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String id;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime createdAt;
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String description;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String metadata;
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String domain;
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String region;
    @JsonProperty(value="cname_target")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<String> cnameTarget;
    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<Ref> certificate;
    @JsonProperty(value="certificate_management_policy")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<ReservedDomainCertPolicy> certificateManagementPolicy;
    @JsonProperty(value="certificate_management_status")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<ReservedDomainCertStatus> certificateManagementStatus;
    @JsonProperty(value="acme_challenge_cname_target")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<String> acmeChallengeCnameTarget;

    @JsonCreator
    public ReservedDomain(@JsonProperty(value="id") String id, @JsonProperty(value="uri") URI uri, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="description") String description, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="domain") String domain, @JsonProperty(value="region") String region, @JsonProperty(value="cname_target") Optional<String> cnameTarget, @JsonProperty(value="certificate") Optional<Ref> certificate, @JsonProperty(value="certificate_management_policy") Optional<ReservedDomainCertPolicy> certificateManagementPolicy, @JsonProperty(value="certificate_management_status") Optional<ReservedDomainCertStatus> certificateManagementStatus, @JsonProperty(value="acme_challenge_cname_target") Optional<String> acmeChallengeCnameTarget) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt is required");
        this.description = Objects.requireNonNull(description, "description is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.domain = Objects.requireNonNull(domain, "domain is required");
        this.region = Objects.requireNonNull(region, "region is required");
        this.cnameTarget = cnameTarget != null ? cnameTarget : Optional.empty();
        this.certificate = certificate != null ? certificate : Optional.empty();
        this.certificateManagementPolicy = certificateManagementPolicy != null ? certificateManagementPolicy : Optional.empty();
        this.certificateManagementStatus = certificateManagementStatus != null ? certificateManagementStatus : Optional.empty();
        this.acmeChallengeCnameTarget = acmeChallengeCnameTarget != null ? acmeChallengeCnameTarget : Optional.empty();
    }

    public String getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRegion() {
        return this.region;
    }

    public Optional<String> getCnameTarget() {
        return this.cnameTarget;
    }

    public Optional<Ref> getCertificate() {
        return this.certificate;
    }

    public Optional<ReservedDomainCertPolicy> getCertificateManagementPolicy() {
        return this.certificateManagementPolicy;
    }

    public Optional<ReservedDomainCertStatus> getCertificateManagementStatus() {
        return this.certificateManagementStatus;
    }

    public Optional<String> getAcmeChallengeCnameTarget() {
        return this.acmeChallengeCnameTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReservedDomain other = (ReservedDomain)o;
        return this.id.equals(other.id) && this.uri.equals(other.uri) && this.createdAt.equals(other.createdAt) && this.description.equals(other.description) && this.metadata.equals(other.metadata) && this.domain.equals(other.domain) && this.region.equals(other.region) && this.cnameTarget.equals(other.cnameTarget) && this.certificate.equals(other.certificate) && this.certificateManagementPolicy.equals(other.certificateManagementPolicy) && this.certificateManagementStatus.equals(other.certificateManagementStatus) && this.acmeChallengeCnameTarget.equals(other.acmeChallengeCnameTarget);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri, this.createdAt, this.description, this.metadata, this.domain, this.region, this.cnameTarget, this.certificate, this.certificateManagementPolicy, this.certificateManagementStatus, this.acmeChallengeCnameTarget);
    }

    public String toString() {
        return "ReservedDomain{id='" + this.id + "', uri='" + this.uri + "', createdAt='" + this.createdAt + "', description='" + this.description + "', metadata='" + this.metadata + "', domain='" + this.domain + "', region='" + this.region + "', cnameTarget='" + this.cnameTarget.orElse("(null)") + "', certificate='" + this.certificate.map(Object::toString).orElse("(null)") + "', certificateManagementPolicy='" + this.certificateManagementPolicy.map(Object::toString).orElse("(null)") + "', certificateManagementStatus='" + this.certificateManagementStatus.map(Object::toString).orElse("(null)") + "', acmeChallengeCnameTarget='" + this.acmeChallengeCnameTarget.orElse("(null)") + "'}";
    }
}

