/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NgrokApiError
extends RuntimeException {
    private final int httpStatusCode;
    private final Optional<String> errorCode;
    private final Map<String, String> details;

    @JsonCreator
    public NgrokApiError(@JsonProperty(value="msg") String message, @JsonProperty(value="status_code") int httpStatusCode, @JsonProperty(value="error_code") Optional<String> errorCode, @JsonProperty(value="details") Map<String, String> details) {
        super(message != null ? message : "HTTP server returned status " + httpStatusCode);
        this.httpStatusCode = httpStatusCode;
        this.errorCode = errorCode != null ? errorCode : Optional.empty();
        this.details = details != null ? details : Collections.emptyMap();
    }

    public NgrokApiError(int httpStatusCode, Optional<String> responseBody, Throwable cause) {
        super(cause.getMessage(), cause);
        this.httpStatusCode = httpStatusCode;
        this.errorCode = Optional.empty();
        this.details = responseBody.map(body -> {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("response_body", (String)body);
            return Collections.unmodifiableMap(details);
        }).orElse(Collections.emptyMap());
    }

    public NgrokApiError(int httpStatusCode) {
        this("HTTP server returned status " + httpStatusCode, httpStatusCode, Optional.empty(), Collections.emptyMap());
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public Optional<String> getErrorCode() {
        return this.errorCode;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public boolean isErrorCode(String ... codes) {
        HashSet<String> codeSet = new HashSet<String>(Arrays.asList(codes));
        return this.errorCode.filter(codeSet::contains).isPresent();
    }
}

