/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.IpRestriction;
import com.ngrok.definitions.Pageable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IpRestrictionList
implements Pageable {
    @JsonProperty(value="ip_restrictions")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<IpRestriction> ipRestrictions;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="next_page_uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<URI> nextPageUri;

    @JsonCreator
    public IpRestrictionList(@JsonProperty(value="ip_restrictions") List<IpRestriction> ipRestrictions, @JsonProperty(value="uri") URI uri, @JsonProperty(value="next_page_uri") Optional<URI> nextPageUri) {
        this.ipRestrictions = ipRestrictions != null ? ipRestrictions : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.nextPageUri = nextPageUri != null ? nextPageUri : Optional.empty();
    }

    public List<IpRestriction> getIpRestrictions() {
        return this.ipRestrictions;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Optional<URI> getNextPageUri() {
        return this.nextPageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpRestrictionList other = (IpRestrictionList)o;
        return this.ipRestrictions.equals(other.ipRestrictions) && this.uri.equals(other.uri) && this.nextPageUri.equals(other.nextPageUri);
    }

    public int hashCode() {
        return Objects.hash(this.ipRestrictions, this.uri, this.nextPageUri);
    }

    public String toString() {
        return "IpRestrictionList{ipRestrictions='" + this.ipRestrictions + "', uri='" + this.uri + "', nextPageUri='" + this.nextPageUri.map(Object::toString).orElse("(null)") + "'}";
    }
}

