/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EndpointMutualTls;
import com.ngrok.definitions.EndpointTlsTermination;
import com.ngrok.definitions.HttpsEdgeRoute;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HttpsEdge {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String id;
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String description;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String metadata;
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime createdAt;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="hostports")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<List<String>> hostports;
    @JsonProperty(value="mutual_tls")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointMutualTls> mutualTls;
    @JsonProperty(value="tls_termination")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EndpointTlsTermination> tlsTermination;
    @JsonProperty(value="routes")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<HttpsEdgeRoute> routes;

    @JsonCreator
    public HttpsEdge(@JsonProperty(value="id") String id, @JsonProperty(value="description") String description, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="uri") URI uri, @JsonProperty(value="hostports") Optional<List<String>> hostports, @JsonProperty(value="mutual_tls") Optional<EndpointMutualTls> mutualTls, @JsonProperty(value="tls_termination") Optional<EndpointTlsTermination> tlsTermination, @JsonProperty(value="routes") List<HttpsEdgeRoute> routes) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.description = Objects.requireNonNull(description, "description is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt is required");
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.hostports = hostports != null ? hostports : Optional.empty();
        this.mutualTls = mutualTls != null ? mutualTls : Optional.empty();
        this.tlsTermination = tlsTermination != null ? tlsTermination : Optional.empty();
        this.routes = routes != null ? routes : Collections.emptyList();
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public URI getUri() {
        return this.uri;
    }

    public Optional<List<String>> getHostports() {
        return this.hostports;
    }

    public Optional<EndpointMutualTls> getMutualTls() {
        return this.mutualTls;
    }

    public Optional<EndpointTlsTermination> getTlsTermination() {
        return this.tlsTermination;
    }

    public List<HttpsEdgeRoute> getRoutes() {
        return this.routes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpsEdge other = (HttpsEdge)o;
        return this.id.equals(other.id) && this.description.equals(other.description) && this.metadata.equals(other.metadata) && this.createdAt.equals(other.createdAt) && this.uri.equals(other.uri) && this.hostports.equals(other.hostports) && this.mutualTls.equals(other.mutualTls) && this.tlsTermination.equals(other.tlsTermination) && this.routes.equals(other.routes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.metadata, this.createdAt, this.uri, this.hostports, this.mutualTls, this.tlsTermination, this.routes);
    }

    public String toString() {
        return "HttpsEdge{id='" + this.id + "', description='" + this.description + "', metadata='" + this.metadata + "', createdAt='" + this.createdAt + "', uri='" + this.uri + "', hostports='" + this.hostports.map(Object::toString).orElse("(null)") + "', mutualTls='" + this.mutualTls.map(Object::toString).orElse("(null)") + "', tlsTermination='" + this.tlsTermination.map(Object::toString).orElse("(null)") + "', routes='" + this.routes + "'}";
    }
}

