/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.FailoverBackend;
import com.ngrok.definitions.Pageable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FailoverBackendList
implements Pageable {
    @JsonProperty(value="backends")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<FailoverBackend> backends;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="next_page_uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<URI> nextPageUri;

    @JsonCreator
    public FailoverBackendList(@JsonProperty(value="backends") List<FailoverBackend> backends, @JsonProperty(value="uri") URI uri, @JsonProperty(value="next_page_uri") Optional<URI> nextPageUri) {
        this.backends = backends != null ? backends : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.nextPageUri = nextPageUri != null ? nextPageUri : Optional.empty();
    }

    public List<FailoverBackend> getBackends() {
        return this.backends;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Optional<URI> getNextPageUri() {
        return this.nextPageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailoverBackendList other = (FailoverBackendList)o;
        return this.backends.equals(other.backends) && this.uri.equals(other.uri) && this.nextPageUri.equals(other.nextPageUri);
    }

    public int hashCode() {
        return Objects.hash(this.backends, this.uri, this.nextPageUri);
    }

    public String toString() {
        return "FailoverBackendList{backends='" + this.backends + "', uri='" + this.uri + "', nextPageUri='" + this.nextPageUri.map(Object::toString).orElse("(null)") + "'}";
    }
}

