/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.AwsAuth;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventTargetKinesis {
    @JsonProperty(value="auth")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final AwsAuth auth;
    @JsonProperty(value="stream_arn")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String streamArn;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EventTargetKinesis(@JsonProperty(value="auth") AwsAuth auth, @JsonProperty(value="stream_arn") String streamArn) {
        this.auth = Objects.requireNonNull(auth, "auth is required");
        this.streamArn = Objects.requireNonNull(streamArn, "streamArn is required");
    }

    public AwsAuth getAuth() {
        return this.auth;
    }

    public String getStreamArn() {
        return this.streamArn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventTargetKinesis other = (EventTargetKinesis)o;
        return this.auth.equals(other.auth) && this.streamArn.equals(other.streamArn);
    }

    public int hashCode() {
        return Objects.hash(this.auth, this.streamArn);
    }

    public String toString() {
        return "EventTargetKinesis{auth='" + this.auth + "', streamArn='" + this.streamArn + "'}";
    }

    public static class Builder {
        private Optional<AwsAuth> auth = Optional.empty();
        private Optional<String> streamArn = Optional.empty();

        private Builder() {
        }

        public Builder auth(AwsAuth auth) {
            this.auth = Optional.of(Objects.requireNonNull(auth, "auth is required"));
            return this;
        }

        public Builder auth(Optional<AwsAuth> auth) {
            this.auth = Objects.requireNonNull(auth, "auth is required");
            return this;
        }

        public Builder streamArn(String streamArn) {
            this.streamArn = Optional.of(Objects.requireNonNull(streamArn, "streamArn is required"));
            return this;
        }

        public Builder streamArn(Optional<String> streamArn) {
            this.streamArn = Objects.requireNonNull(streamArn, "streamArn is required");
            return this;
        }

        public EventTargetKinesis build() {
            return new EventTargetKinesis(this.auth.orElse(null), this.streamArn.orElse(""));
        }
    }
}

