/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.AwsAuth;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventTargetFirehose {
    @JsonProperty(value="auth")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final AwsAuth auth;
    @JsonProperty(value="delivery_stream_arn")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String deliveryStreamArn;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EventTargetFirehose(@JsonProperty(value="auth") AwsAuth auth, @JsonProperty(value="delivery_stream_arn") String deliveryStreamArn) {
        this.auth = Objects.requireNonNull(auth, "auth is required");
        this.deliveryStreamArn = Objects.requireNonNull(deliveryStreamArn, "deliveryStreamArn is required");
    }

    public AwsAuth getAuth() {
        return this.auth;
    }

    public String getDeliveryStreamArn() {
        return this.deliveryStreamArn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventTargetFirehose other = (EventTargetFirehose)o;
        return this.auth.equals(other.auth) && this.deliveryStreamArn.equals(other.deliveryStreamArn);
    }

    public int hashCode() {
        return Objects.hash(this.auth, this.deliveryStreamArn);
    }

    public String toString() {
        return "EventTargetFirehose{auth='" + this.auth + "', deliveryStreamArn='" + this.deliveryStreamArn + "'}";
    }

    public static class Builder {
        private Optional<AwsAuth> auth = Optional.empty();
        private Optional<String> deliveryStreamArn = Optional.empty();

        private Builder() {
        }

        public Builder auth(AwsAuth auth) {
            this.auth = Optional.of(Objects.requireNonNull(auth, "auth is required"));
            return this;
        }

        public Builder auth(Optional<AwsAuth> auth) {
            this.auth = Objects.requireNonNull(auth, "auth is required");
            return this;
        }

        public Builder deliveryStreamArn(String deliveryStreamArn) {
            this.deliveryStreamArn = Optional.of(Objects.requireNonNull(deliveryStreamArn, "deliveryStreamArn is required"));
            return this;
        }

        public Builder deliveryStreamArn(Optional<String> deliveryStreamArn) {
            this.deliveryStreamArn = Objects.requireNonNull(deliveryStreamArn, "deliveryStreamArn is required");
            return this;
        }

        public EventTargetFirehose build() {
            return new EventTargetFirehose(this.auth.orElse(null), this.deliveryStreamArn.orElse(""));
        }
    }
}

