/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.AwsAuth;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventTargetCloudwatchLogs {
    @JsonProperty(value="auth")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final AwsAuth auth;
    @JsonProperty(value="log_group_arn")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String logGroupArn;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EventTargetCloudwatchLogs(@JsonProperty(value="auth") AwsAuth auth, @JsonProperty(value="log_group_arn") String logGroupArn) {
        this.auth = Objects.requireNonNull(auth, "auth is required");
        this.logGroupArn = Objects.requireNonNull(logGroupArn, "logGroupArn is required");
    }

    public AwsAuth getAuth() {
        return this.auth;
    }

    public String getLogGroupArn() {
        return this.logGroupArn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventTargetCloudwatchLogs other = (EventTargetCloudwatchLogs)o;
        return this.auth.equals(other.auth) && this.logGroupArn.equals(other.logGroupArn);
    }

    public int hashCode() {
        return Objects.hash(this.auth, this.logGroupArn);
    }

    public String toString() {
        return "EventTargetCloudwatchLogs{auth='" + this.auth + "', logGroupArn='" + this.logGroupArn + "'}";
    }

    public static class Builder {
        private Optional<AwsAuth> auth = Optional.empty();
        private Optional<String> logGroupArn = Optional.empty();

        private Builder() {
        }

        public Builder auth(AwsAuth auth) {
            this.auth = Optional.of(Objects.requireNonNull(auth, "auth is required"));
            return this;
        }

        public Builder auth(Optional<AwsAuth> auth) {
            this.auth = Objects.requireNonNull(auth, "auth is required");
            return this;
        }

        public Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = Optional.of(Objects.requireNonNull(logGroupArn, "logGroupArn is required"));
            return this;
        }

        public Builder logGroupArn(Optional<String> logGroupArn) {
            this.logGroupArn = Objects.requireNonNull(logGroupArn, "logGroupArn is required");
            return this;
        }

        public EventTargetCloudwatchLogs build() {
            return new EventTargetCloudwatchLogs(this.auth.orElse(null), this.logGroupArn.orElse(""));
        }
    }
}

