/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EventTargetCloudwatchLogs;
import com.ngrok.definitions.EventTargetFirehose;
import com.ngrok.definitions.EventTargetKinesis;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventTarget {
    @JsonProperty(value="firehose")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EventTargetFirehose> firehose;
    @JsonProperty(value="kinesis")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EventTargetKinesis> kinesis;
    @JsonProperty(value="cloudwatch_logs")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<EventTargetCloudwatchLogs> cloudwatchLogs;

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonCreator
    private EventTarget(@JsonProperty(value="firehose") Optional<EventTargetFirehose> firehose, @JsonProperty(value="kinesis") Optional<EventTargetKinesis> kinesis, @JsonProperty(value="cloudwatch_logs") Optional<EventTargetCloudwatchLogs> cloudwatchLogs) {
        this.firehose = firehose != null ? firehose : Optional.empty();
        this.kinesis = kinesis != null ? kinesis : Optional.empty();
        this.cloudwatchLogs = cloudwatchLogs != null ? cloudwatchLogs : Optional.empty();
    }

    public Optional<EventTargetFirehose> getFirehose() {
        return this.firehose;
    }

    public Optional<EventTargetKinesis> getKinesis() {
        return this.kinesis;
    }

    public Optional<EventTargetCloudwatchLogs> getCloudwatchLogs() {
        return this.cloudwatchLogs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventTarget other = (EventTarget)o;
        return this.firehose.equals(other.firehose) && this.kinesis.equals(other.kinesis) && this.cloudwatchLogs.equals(other.cloudwatchLogs);
    }

    public int hashCode() {
        return Objects.hash(this.firehose, this.kinesis, this.cloudwatchLogs);
    }

    public String toString() {
        return "EventTarget{firehose='" + this.firehose.map(Object::toString).orElse("(null)") + "', kinesis='" + this.kinesis.map(Object::toString).orElse("(null)") + "', cloudwatchLogs='" + this.cloudwatchLogs.map(Object::toString).orElse("(null)") + "'}";
    }

    public static class Builder {
        private Optional<EventTargetFirehose> firehose = Optional.empty();
        private Optional<EventTargetKinesis> kinesis = Optional.empty();
        private Optional<EventTargetCloudwatchLogs> cloudwatchLogs = Optional.empty();

        private Builder() {
        }

        public Builder firehose(EventTargetFirehose firehose) {
            this.firehose = Optional.of(Objects.requireNonNull(firehose, "firehose is required"));
            return this;
        }

        public Builder firehose(Optional<EventTargetFirehose> firehose) {
            this.firehose = Objects.requireNonNull(firehose, "firehose is required");
            return this;
        }

        public Builder kinesis(EventTargetKinesis kinesis) {
            this.kinesis = Optional.of(Objects.requireNonNull(kinesis, "kinesis is required"));
            return this;
        }

        public Builder kinesis(Optional<EventTargetKinesis> kinesis) {
            this.kinesis = Objects.requireNonNull(kinesis, "kinesis is required");
            return this;
        }

        public Builder cloudwatchLogs(EventTargetCloudwatchLogs cloudwatchLogs) {
            this.cloudwatchLogs = Optional.of(Objects.requireNonNull(cloudwatchLogs, "cloudwatchLogs is required"));
            return this;
        }

        public Builder cloudwatchLogs(Optional<EventTargetCloudwatchLogs> cloudwatchLogs) {
            this.cloudwatchLogs = Objects.requireNonNull(cloudwatchLogs, "cloudwatchLogs is required");
            return this;
        }

        public EventTarget build() {
            return new EventTarget(this.firehose, this.kinesis, this.cloudwatchLogs);
        }
    }
}

