/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EventSubscription;
import com.ngrok.definitions.Pageable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventSubscriptionList
implements Pageable {
    @JsonProperty(value="event_subscriptions")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<EventSubscription> eventSubscriptions;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="next_page_uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final Optional<URI> nextPageUri;

    @JsonCreator
    public EventSubscriptionList(@JsonProperty(value="event_subscriptions") List<EventSubscription> eventSubscriptions, @JsonProperty(value="uri") URI uri, @JsonProperty(value="next_page_uri") Optional<URI> nextPageUri) {
        this.eventSubscriptions = eventSubscriptions != null ? eventSubscriptions : Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.nextPageUri = nextPageUri != null ? nextPageUri : Optional.empty();
    }

    public List<EventSubscription> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public Optional<URI> getNextPageUri() {
        return this.nextPageUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSubscriptionList other = (EventSubscriptionList)o;
        return this.eventSubscriptions.equals(other.eventSubscriptions) && this.uri.equals(other.uri) && this.nextPageUri.equals(other.nextPageUri);
    }

    public int hashCode() {
        return Objects.hash(this.eventSubscriptions, this.uri, this.nextPageUri);
    }

    public String toString() {
        return "EventSubscriptionList{eventSubscriptions='" + this.eventSubscriptions + "', uri='" + this.uri + "', nextPageUri='" + this.nextPageUri.map(Object::toString).orElse("(null)") + "'}";
    }
}

