/*
 * Decompiled with CFR 0.152.
 */
package com.ngrok.definitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ngrok.definitions.EventSource;
import com.ngrok.definitions.Ref;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventSubscription {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String id;
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final URI uri;
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final OffsetDateTime createdAt;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String metadata;
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final String description;
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<EventSource> sources;
    @JsonProperty(value="destinations")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private final List<Ref> destinations;

    @JsonCreator
    public EventSubscription(@JsonProperty(value="id") String id, @JsonProperty(value="uri") URI uri, @JsonProperty(value="created_at") OffsetDateTime createdAt, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="description") String description, @JsonProperty(value="sources") List<EventSource> sources, @JsonProperty(value="destinations") List<Ref> destinations) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.uri = Objects.requireNonNull(uri, "uri is required");
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.description = Objects.requireNonNull(description, "description is required");
        this.sources = sources != null ? sources : Collections.emptyList();
        this.destinations = destinations != null ? destinations : Collections.emptyList();
    }

    public String getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EventSource> getSources() {
        return this.sources;
    }

    public List<Ref> getDestinations() {
        return this.destinations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSubscription other = (EventSubscription)o;
        return this.id.equals(other.id) && this.uri.equals(other.uri) && this.createdAt.equals(other.createdAt) && this.metadata.equals(other.metadata) && this.description.equals(other.description) && this.sources.equals(other.sources) && this.destinations.equals(other.destinations);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri, this.createdAt, this.metadata, this.description, this.sources, this.destinations);
    }

    public String toString() {
        return "EventSubscription{id='" + this.id + "', uri='" + this.uri + "', createdAt='" + this.createdAt + "', metadata='" + this.metadata + "', description='" + this.description + "', sources='" + this.sources + "', destinations='" + this.destinations + "'}";
    }
}

